/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.dev;

import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentNode;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;

public class POIFSLister {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            POIFSLister.viewFile(stringArray[i]);
        }
    }

    public static void viewFile(String string) throws IOException {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(string));
        POIFSLister.displayDirectory(pOIFSFileSystem.getRoot(), "");
    }

    public static void displayDirectory(DirectoryNode directoryNode, String string) {
        System.out.println(string + directoryNode.getName() + " -");
        String string2 = string + "  ";
        Iterator iterator = directoryNode.getEntries();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof DirectoryNode) {
                POIFSLister.displayDirectory((DirectoryNode)e, string2);
                continue;
            }
            DocumentNode documentNode = (DocumentNode)e;
            String string3 = documentNode.getName();
            if (string3.charAt(0) < '\n') {
                String string4 = "(0x0" + string3.charAt(0) + ")" + string3.substring(1);
                string3 = string3.substring(1) + " <" + string4 + ">";
            }
            System.out.println(string2 + string3);
        }
    }
}

