/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

import com.fr.third.org.apache.poi.hssf.record.MergeCellsRecord;

public class Region
implements Comparable {
    private int rowFrom;
    private short colFrom;
    private int rowTo;
    private short colTo;

    public Region() {
    }

    public Region(int n, short s, int n2, short s2) {
        this.rowFrom = n;
        this.rowTo = n2;
        this.colFrom = s;
        this.colTo = s2;
    }

    public Region(MergeCellsRecord.MergedRegion mergedRegion) {
        this(mergedRegion.row_from, mergedRegion.col_from, mergedRegion.row_to, mergedRegion.col_to);
    }

    public short getColumnFrom() {
        return this.colFrom;
    }

    public int getRowFrom() {
        return this.rowFrom;
    }

    public short getColumnTo() {
        return this.colTo;
    }

    public int getRowTo() {
        return this.rowTo;
    }

    public void setColumnFrom(short s) {
        this.colFrom = s;
    }

    public void setRowFrom(int n) {
        this.rowFrom = n;
    }

    public void setColumnTo(short s) {
        this.colTo = s;
    }

    public void setRowTo(int n) {
        this.rowTo = n;
    }

    public boolean contains(int n, short s) {
        return this.rowFrom <= n && this.rowTo >= n && this.colFrom <= s && this.colTo >= s;
    }

    public boolean equals(Region region) {
        return this.compareTo(region) == 0;
    }

    public int compareTo(Region region) {
        if (this.getRowFrom() == region.getRowFrom() && this.getColumnFrom() == region.getColumnFrom() && this.getRowTo() == region.getRowTo() && this.getColumnTo() == region.getColumnTo()) {
            return 0;
        }
        if (this.getRowFrom() < region.getRowFrom() || this.getColumnFrom() < region.getColumnFrom() || this.getRowTo() < region.getRowTo() || this.getColumnTo() < region.getColumnTo()) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Region)object);
    }

    public int getArea() {
        return (1 + (this.getRowTo() - this.getRowFrom())) * (1 + (this.getColumnTo() - this.getColumnFrom()));
    }
}

