/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

public class RangeAddress {
    static final int WRONG_POS = -1;
    static final int MAX_HEIGHT = 66666;
    static final char SO_FORMNAME_ENCLOSURE = '\'';
    String m_sheetName;
    String m_cellFrom;
    String m_cellTo;

    public RangeAddress(String string) {
        this.init(string);
    }

    public RangeAddress(int n, int n2, int n3, int n4) {
        this.init(this.numTo26Sys(n) + n2 + ":" + this.numTo26Sys(n3) + n4);
    }

    public String getAddress() {
        String string = "";
        if (this.m_sheetName != null) {
            string = string + this.m_sheetName + "!";
        }
        if (this.m_cellFrom != null) {
            string = string + this.m_cellFrom;
            if (this.m_cellTo != null) {
                string = string + ":" + this.m_cellTo;
            }
        }
        return string;
    }

    public String getSheetName() {
        return this.m_sheetName;
    }

    public String getRange() {
        String string = "";
        if (this.m_cellFrom != null) {
            string = string + this.m_cellFrom;
            if (this.m_cellTo != null) {
                string = string + ":" + this.m_cellTo;
            }
        }
        return string;
    }

    public boolean isCellOk(String string) {
        if (string != null) {
            return this.getYPosition(string) != -1 && this.getXPosition(string) != -1;
        }
        return false;
    }

    public boolean isSheetNameOk() {
        return RangeAddress.isSheetNameOk(this.m_sheetName);
    }

    private static boolean intern_isSheetNameOk(String string, boolean bl) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || bl && c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isSheetNameOk(String string) {
        boolean bl = false;
        bl = string != null && !string.equals("") ? RangeAddress.intern_isSheetNameOk(string, true) : true;
        return bl;
    }

    public String getFromCell() {
        return this.m_cellFrom;
    }

    public String getToCell() {
        return this.m_cellTo;
    }

    public int getWidth() {
        if (this.m_cellFrom != null && this.m_cellTo != null) {
            int n = this.getXPosition(this.m_cellTo);
            int n2 = this.getXPosition(this.m_cellFrom);
            if (n == -1 || n2 == -1) {
                return 0;
            }
            return n - n2 + 1;
        }
        return 0;
    }

    public int getHeight() {
        if (this.m_cellFrom != null && this.m_cellTo != null) {
            int n = this.getYPosition(this.m_cellTo);
            int n2 = this.getYPosition(this.m_cellFrom);
            if (n == -1 || n2 == -1) {
                return 0;
            }
            return n - n2 + 1;
        }
        return 0;
    }

    public void setSize(int n, int n2) {
        if (this.m_cellFrom == null) {
            this.m_cellFrom = "a1";
        }
        int n3 = this.getXPosition(this.m_cellFrom);
        int n4 = this.getYPosition(this.m_cellFrom);
        this.m_cellTo = this.numTo26Sys(n3 + n - 1);
        this.m_cellTo = this.m_cellTo + String.valueOf(n4 + n2 - 1);
    }

    public boolean hasSheetName() {
        return this.m_sheetName != null;
    }

    public boolean hasRange() {
        return this.m_cellFrom != null && this.m_cellTo != null && !this.m_cellFrom.equals(this.m_cellTo);
    }

    public boolean hasCell() {
        return this.m_cellFrom != null;
    }

    private void init(String string) {
        string = this.removeString(string, "$");
        string = this.removeString(string, "'");
        String[] stringArray = this.parseURL(string);
        this.m_sheetName = stringArray[0];
        this.m_cellFrom = stringArray[1];
        this.m_cellTo = stringArray[2];
        if (this.m_cellTo == null) {
            this.m_cellTo = this.m_cellFrom;
        }
        this.m_cellTo = this.removeString(this.m_cellTo, ".");
    }

    private String[] parseURL(String string) {
        String[] stringArray = new String[3];
        int n = string.indexOf(58);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            n = string2.indexOf(33);
            if (n >= 0) {
                stringArray[0] = string2.substring(0, n);
                stringArray[1] = string2.substring(n + 1);
            } else {
                stringArray[1] = string2;
            }
            n = string3.indexOf(33);
            stringArray[2] = n >= 0 ? string3.substring(n + 1) : string3;
        } else {
            n = string.indexOf(33);
            if (n >= 0) {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
            } else {
                stringArray[1] = string;
            }
        }
        return stringArray;
    }

    public int getYPosition(String string) {
        int n = -1;
        if ((string = string.trim()).length() != 0) {
            String string2 = this.getDigitPart(string);
            try {
                n = Integer.parseInt(string2);
                if (n > 66666) {
                    n = -1;
                }
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        return n;
    }

    private static boolean isLetter(String string) {
        boolean bl = true;
        if (!string.equals("")) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isLetter(c)) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int getXPosition(String string) {
        int n = -1;
        String string2 = this.filter$(string);
        string2 = this.getCharPart(string);
        if (RangeAddress.isLetter(string2) && (string2.length() == 2 || string2.length() == 1)) {
            n = this.get26Sys(string2);
        }
        return n;
    }

    public String getDigitPart(String string) {
        String string2 = "";
        int n = this.getFirstDigitPosition(string);
        if (n >= 0) {
            string2 = string.substring(n);
        }
        return string2;
    }

    public String getCharPart(String string) {
        String string2 = "";
        int n = this.getFirstDigitPosition(string);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String filter$(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$') continue;
            string2 = string2 + c;
        }
        return string2;
    }

    private int getFirstDigitPosition(String string) {
        int n = -1;
        if (string != null && string.trim().length() == 0) {
            return n;
        }
        string = string.trim();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    public int get26Sys(String string) {
        int n = 0;
        int n2 = 1;
        if (string != "") {
            for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                int n3 = Character.getNumericValue(c) - Character.getNumericValue('A') + 1;
                n += n3 * n2;
                n2 *= 26;
            }
            return n;
        }
        return -1;
    }

    public String numTo26Sys(int n) {
        boolean bl = false;
        String string = "";
        do {
            int n2 = --n % 26;
            int n3 = 65 + n2;
            string = (char)n3 + string;
        } while ((n /= 26) > 0);
        return string;
    }

    public String replaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        while ((n = stringBuffer.toString().indexOf(string2, n)) > -1) {
            stringBuffer.replace(n, n + string2.length(), string3);
        }
        return stringBuffer.toString();
    }

    public String removeString(String string, String string2) {
        return this.replaceString(string, string2, "");
    }
}

