/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

import com.fr.third.org.apache.poi.hssf.record.FilePassRecord;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class PWDUtils {
    static byte[] seeds = new byte[]{-69, -1, -1, -70, -1, -1, -71, -128, 0, -66, 15, 0, -65, 15, 0};

    public static short getPasswordHash(byte[] byArray) {
        short s = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] << i + 1;
            s = (short)(s ^ (short)(n & Short.MAX_VALUE | n >> 15));
        }
        s = (short)(s ^ (short)byArray.length);
        s = (short)(s ^ 0xCE4B);
        return s;
    }

    public static short getEncryptionKey(byte[] byArray) {
        int n = 0;
        int n2 = 32768;
        int n3 = 65535;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)(byArray[byArray.length - 1 - i] & 0x7F);
            for (int j = 0; j < 8; ++j) {
                if (((n2 = n2 << 1 & 0xFFFF | n2 >> 15) & 1) == 1) {
                    n2 = (n2 ^ 0x1020) & 0xFFFF;
                }
                if (((n3 = n3 << 1 & 0xFFFF | n3 >> 15) & 1) == 1) {
                    n3 = (n3 ^ 0x1020) & 0xFFFF;
                }
                if ((by & 1) == 1) {
                    n = (n ^ n2) & 0xFFFF;
                }
                by = (byte)(by >> 1);
            }
        }
        n = (n ^ n3) & 0xFFFF;
        return (short)(n & 0xFFFF);
    }

    public static byte[] getKeySequence(byte[] byArray, short s) {
        int n;
        byte[] byArray2 = new byte[16];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        System.arraycopy(seeds, 0, byArray2, n2, 16 - n2);
        byte by = (byte)(s & 0xFF);
        byte by2 = (byte)(s >> 8 & 0xFF);
        for (n = 0; n < 16; n += 2) {
            int n3 = n;
            byArray2[n3] = (byte)(byArray2[n3] ^ by);
            int n4 = n + 1;
            byArray2[n4] = (byte)(byArray2[n4] ^ by2);
        }
        for (n = 0; n < 16; ++n) {
            byArray2[n] = (byte)(byArray2[n] << 2 | byArray2[n] >> 6 & 3);
        }
        return byArray2;
    }

    public static void writeRecord(int n, byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = n + n2 + n3 & 0xF;
        for (int i = 0; i < n3 - n2; ++i) {
            byte by = (byte)(byArray[i + n + n2] ^ byArray2[n4]);
            byArray[i + n + n2] = by = (byte)(by >> 3 & 0x1F | by << 5);
            n4 = n4 + 1 & 0xF;
        }
    }

    public static void readRecord(int n, byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = n + n2 + n3 & 0xF;
        for (int i = 0; i < n3 - n2; ++i) {
            byte by = byArray[i + n + n2];
            by = (byte)(by << 3 | by >> 5 & 7);
            byArray[i + n + n2] = (byte)(by ^ byArray2[n4]);
            n4 = n4 + 1 & 0xF;
        }
    }

    public static void encrypt(byte[] byArray, FilePassRecord filePassRecord) {
        short s;
        byte[] byArray2 = PWDUtils.getKeySequence(filePassRecord.getPassword().getBytes(), filePassRecord.getKey());
        for (int i = 0; i < byArray.length; i += 4 + s) {
            short s2 = LittleEndian.getShort(byArray, i + 0);
            s = LittleEndian.getShort(byArray, i + 2);
            if (s2 == 133) {
                PWDUtils.writeRecord(i + 4, byArray, 4, s, byArray2);
                continue;
            }
            if (s2 == 2057 || s2 == 47 || s2 == 225) continue;
            PWDUtils.writeRecord(i + 4, byArray, 0, s, byArray2);
        }
    }
}

