/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.util.ArrayList;

public class HSSFCellRangeAddress {
    private static POILogger logger = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$util$HSSFCellRangeAddress == null ? (class$com$fr$third$org$apache$poi$hssf$util$HSSFCellRangeAddress = HSSFCellRangeAddress.class$("com.fr.third.org.apache.poi.hssf.util.HSSFCellRangeAddress")) : class$com$fr$third$org$apache$poi$hssf$util$HSSFCellRangeAddress);
    private short field_addr_number;
    private ArrayList field_regions_list;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$util$HSSFCellRangeAddress;

    public HSSFCellRangeAddress() {
    }

    public HSSFCellRangeAddress(RecordInputStream recordInputStream) {
        this.fillFields(recordInputStream);
    }

    public void fillFields(RecordInputStream recordInputStream) {
        this.field_addr_number = recordInputStream.readShort();
        this.field_regions_list = new ArrayList(this.field_addr_number);
        for (int i = 0; i < this.field_addr_number; ++i) {
            short s = recordInputStream.readShort();
            short s2 = recordInputStream.readShort();
            short s3 = s;
            short s4 = s2;
            if (recordInputStream.remaining() >= 4) {
                s3 = recordInputStream.readShort();
                s4 = recordInputStream.readShort();
            } else {
                logger.log(5, "Ran out of data reading cell references for DVRecord");
                i = this.field_addr_number;
            }
            AddrStructure addrStructure = new AddrStructure(s, s2, s3, s4);
            this.field_regions_list.add(addrStructure);
        }
    }

    public short getADDRStructureNumber() {
        return this.field_addr_number;
    }

    public int addADDRStructure(short s, short s2, short s3, short s4) {
        if (this.field_regions_list == null) {
            this.field_addr_number = 0;
            this.field_regions_list = new ArrayList(10);
        }
        AddrStructure addrStructure = new AddrStructure(s, s3, s2, s4);
        this.field_regions_list.add(addrStructure);
        this.field_addr_number = (short)(this.field_addr_number + 1);
        return this.field_addr_number;
    }

    public void removeADDRStructureAt(int n) {
        this.field_regions_list.remove(n);
        this.field_addr_number = (short)(this.field_addr_number - 1);
    }

    public AddrStructure getADDRStructureAt(int n) {
        return (AddrStructure)this.field_regions_list.get(n);
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 2;
        LittleEndian.putShort(byArray, n, this.getADDRStructureNumber());
        for (int i = 0; i < this.getADDRStructureNumber(); ++i) {
            AddrStructure addrStructure = this.getADDRStructureAt(i);
            LittleEndian.putShort(byArray, n + n2, addrStructure.getFirstRow());
            LittleEndian.putShort(byArray, n + (n2 += 2), addrStructure.getLastRow());
            LittleEndian.putShort(byArray, n + (n2 += 2), addrStructure.getFirstColumn());
            LittleEndian.putShort(byArray, n + (n2 += 2), addrStructure.getLastColumn());
            n2 += 2;
        }
        return this.getSize();
    }

    public int getSize() {
        return 2 + this.field_addr_number * 8;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AddrStructure {
        private short _first_row;
        private short _first_col;
        private short _last_row;
        private short _last_col;

        public AddrStructure(short s, short s2, short s3, short s4) {
            this._first_row = s;
            this._last_row = s2;
            this._first_col = s3;
            this._last_col = s4;
        }

        public short getFirstColumn() {
            return this._first_col;
        }

        public short getFirstRow() {
            return this._first_row;
        }

        public short getLastColumn() {
            return this._last_col;
        }

        public short getLastRow() {
            return this._last_row;
        }

        public void setFirstColumn(short s) {
            this._first_col = s;
        }

        public void setFirstRow(short s) {
            this._first_row = s;
        }

        public void setLastColumn(short s) {
            this._last_col = s;
        }

        public void setLastRow(short s) {
            this._last_row = s;
        }
    }
}

