/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

import com.fr.third.org.apache.poi.hssf.record.formula.SheetNameFormatter;

public final class CellReference {
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private final int _rowIndex;
    private final int _colIndex;
    private final String _sheetName;
    private final boolean _isRowAbs;
    private final boolean _isColAbs;

    public CellReference(String string) {
        String[] stringArray = CellReference.separateRefParts(string);
        this._sheetName = stringArray[0];
        String string2 = stringArray[1];
        if (string2.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + string + "'");
        }
        boolean bl = this._isColAbs = string2.charAt(0) == '$';
        if (this._isColAbs) {
            string2 = string2.substring(1);
        }
        this._colIndex = this.convertColStringToNum(string2);
        String string3 = stringArray[2];
        if (string3.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + string + "'");
        }
        boolean bl2 = this._isRowAbs = string3.charAt(0) == '$';
        if (this._isRowAbs) {
            string3 = string3.substring(1);
        }
        this._rowIndex = Integer.parseInt(string3) - 1;
    }

    public CellReference(int n, int n2, boolean bl, boolean bl2) {
        this(null, n, n2, bl, bl2);
    }

    public CellReference(String string, int n, int n2, boolean bl, boolean bl2) {
        if (n < -1) {
            throw new IllegalArgumentException("row index may not be negative");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("column index may not be negative");
        }
        this._sheetName = string;
        this._rowIndex = n;
        this._colIndex = n2;
        this._isRowAbs = bl;
        this._isColAbs = bl2;
    }

    public int getRow() {
        return this._rowIndex;
    }

    public short getCol() {
        return (short)this._colIndex;
    }

    public boolean isRowAbsolute() {
        return this._isRowAbs;
    }

    public boolean isColAbsolute() {
        return this._isColAbs;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    private int convertColStringToNum(String string) {
        int n = string.length() - 1;
        int n2 = 0;
        int n3 = 0;
        for (int i = n; i > -1; --i) {
            char c = string.charAt(i);
            n2 = n3 == 0 ? (n2 += Character.getNumericValue(c) - 9) : (n2 += (Character.getNumericValue(c) - 9) * (n3 * 26));
            ++n3;
        }
        return n2 - 1;
    }

    private static String[] separateRefParts(String string) {
        char c;
        int n = string.lastIndexOf(33);
        String string2 = CellReference.parseSheetName(string, n);
        int n2 = n + 1;
        int n3 = string.length();
        int n4 = n2;
        if (string.charAt(n4) == '$') {
            ++n4;
        }
        while (n4 < n3 && !Character.isDigit(c = string.charAt(n4)) && c != '$') {
            ++n4;
        }
        return new String[]{string2, string.substring(n2, n4), string.substring(n4)};
    }

    private static String parseSheetName(String string, int n) {
        boolean bl;
        if (n < 0) {
            return null;
        }
        boolean bl2 = bl = string.charAt(0) == '\'';
        if (!bl) {
            return string.substring(0, n);
        }
        int n2 = n - 1;
        if (string.charAt(n2) != '\'') {
            throw new RuntimeException("Mismatched quotes: (" + string + ")");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 1; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\'') {
                stringBuffer.append(c);
                continue;
            }
            if (i < n2 && string.charAt(i + 1) == '\'') {
                ++i;
                stringBuffer.append(c);
                continue;
            }
            throw new RuntimeException("Bad sheet name quote escaping: (" + string + ")");
        }
        return stringBuffer.toString();
    }

    protected static String convertNumToColString(int n) {
        String string = null;
        int n2 = n % 26;
        int n3 = n / 26;
        char c = (char)(n2 + 65);
        char c2 = (char)(n3 + 64);
        string = n3 == 0 ? "" + c : "" + c2 + "" + c;
        return string;
    }

    public String formatAsString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this._sheetName != null) {
            SheetNameFormatter.appendFormat(stringBuffer, this._sheetName);
            stringBuffer.append('!');
        }
        this.appendCellReference(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void appendCellReference(StringBuffer stringBuffer) {
        if (this._isColAbs) {
            stringBuffer.append('$');
        }
        stringBuffer.append(CellReference.convertNumToColString(this._colIndex));
        if (this._isRowAbs) {
            stringBuffer.append('$');
        }
        stringBuffer.append(this._rowIndex + 1);
    }
}

