/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

import com.fr.third.org.apache.poi.hssf.record.formula.AreaI;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class AreaReference {
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char CELL_DELIMITER = ':';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private final CellReference _firstCell;
    private final CellReference _lastCell;
    private final boolean _isSingleCell;

    public AreaReference(String string) {
        if (!AreaReference.isContiguous(string)) {
            throw new IllegalArgumentException("References passed to the AreaReference must be contiguous, use generateContiguous(ref) if you have non-contiguous references");
        }
        String[] stringArray = AreaReference.separateAreaRefs(string);
        if (stringArray.length == 2 && stringArray[0].length() == 1 && stringArray[1].length() == 1 && stringArray[0].charAt(0) >= 'A' && stringArray[0].charAt(0) <= 'Z' && stringArray[1].charAt(0) >= 'A' && stringArray[1].charAt(0) <= 'Z') {
            stringArray[0] = stringArray[0] + "$1";
            stringArray[1] = stringArray[1] + "$65536";
        }
        this._firstCell = new CellReference(stringArray[0]);
        if (stringArray.length == 2) {
            this._lastCell = new CellReference(stringArray[1]);
            this._isSingleCell = false;
        } else {
            this._lastCell = this._firstCell;
            this._isSingleCell = true;
        }
    }

    public AreaReference(CellReference cellReference, CellReference cellReference2) {
        this._firstCell = cellReference;
        this._lastCell = cellReference2;
        this._isSingleCell = false;
    }

    public static boolean isContiguous(String string) {
        return string.indexOf(44) == -1;
    }

    public static boolean isWholeColumnReference(CellReference cellReference, CellReference cellReference2) {
        return cellReference.getRow() == 0 && cellReference.isRowAbsolute() && cellReference2.getRow() == 65535 && cellReference2.isRowAbsolute();
    }

    public boolean isWholeColumnReference() {
        return AreaReference.isWholeColumnReference(this._firstCell, this._lastCell);
    }

    public static AreaReference[] generateContiguous(String string) {
        ArrayList<AreaReference> arrayList = new ArrayList<AreaReference>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new AreaReference(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new AreaReference[arrayList.size()]);
    }

    public boolean isSingleCell() {
        return this._isSingleCell;
    }

    public CellReference getFirstCell() {
        return this._firstCell;
    }

    public CellReference getLastCell() {
        return this._lastCell;
    }

    public CellReference[] getAllReferencedCells() {
        if (this._isSingleCell) {
            return new CellReference[]{this._firstCell};
        }
        int n = Math.min(this._firstCell.getRow(), this._lastCell.getRow());
        int n2 = Math.max(this._firstCell.getRow(), this._lastCell.getRow());
        int n3 = Math.min(this._firstCell.getCol(), this._lastCell.getCol());
        int n4 = Math.max(this._firstCell.getCol(), this._lastCell.getCol());
        String string = this._firstCell.getSheetName();
        ArrayList<CellReference> arrayList = new ArrayList<CellReference>();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                CellReference cellReference = new CellReference(string, i, j, this._firstCell.isRowAbsolute(), this._firstCell.isColAbsolute());
                arrayList.add(cellReference);
            }
        }
        return arrayList.toArray(new CellReference[arrayList.size()]);
    }

    public String formatAsString() {
        if (this.isWholeColumnReference()) {
            return CellReference.convertNumToColString(this._firstCell.getCol()) + ":" + CellReference.convertNumToColString(this._lastCell.getCol());
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this._firstCell.formatAsString());
        if (!this._isSingleCell) {
            stringBuffer.append(':');
            if (this._lastCell.getSheetName() == null) {
                stringBuffer.append(this._lastCell.formatAsString());
            } else {
                this._lastCell.appendCellReference(stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    public static String formatAsString(AreaI areaI) {
        CellReference cellReference;
        CellReference cellReference2 = new CellReference(areaI.getFirstRow(), areaI.getFirstColumn(), !areaI.isFirstRowRelative(), !areaI.isFirstColRelative());
        if (AreaReference.isWholeColumnReference(cellReference2, cellReference = new CellReference(areaI.getLastRow(), areaI.getLastColumn(), !areaI.isLastRowRelative(), !areaI.isLastColRelative()))) {
            return new AreaReference(cellReference2, cellReference).formatAsString();
        }
        return cellReference2.formatAsString() + ":" + cellReference.formatAsString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String[] separateAreaRefs(String string) {
        int n = string.length();
        int n2 = -1;
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case ':': {
                    if (!bl) {
                        if (n2 >= 0) {
                            throw new IllegalArgumentException("More than one cell delimiter ':' appears in area reference '" + string + "'");
                        }
                        n2 = i;
                    }
                }
                default: {
                    continue block4;
                }
                case '\'': {
                    if (!bl) {
                        bl = true;
                        continue block4;
                    }
                    if (i >= n - 1) {
                        throw new IllegalArgumentException("Area reference '" + string + "' ends with special name delimiter '" + '\'' + "'");
                    }
                    if (string.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    bl = false;
                }
            }
        }
        if (n2 < 0) {
            return new String[]{string};
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (string3.indexOf(33) >= 0) {
            throw new RuntimeException("Unexpected ! in second cell reference of '" + string + "'");
        }
        int n3 = string2.lastIndexOf(33);
        if (n3 < 0) {
            return new String[]{string2, string3};
        }
        String string4 = string2.substring(0, n3 + 1);
        return new String[]{string2, string4 + string3};
    }
}

