/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.POIDocument;
import com.fr.third.org.apache.poi.ddf.EscherBSERecord;
import com.fr.third.org.apache.poi.ddf.EscherBitmapBlip;
import com.fr.third.org.apache.poi.ddf.EscherBlipRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.hssf.eventmodel.EventRecordFactory;
import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import com.fr.third.org.apache.poi.hssf.record.BackupRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtendedFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.FontRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.NameRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemFuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnionPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFName;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFObjectData;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPalette;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPictureData;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.hssf.util.PWDUtils;
import com.fr.third.org.apache.poi.hssf.util.SheetReferences;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class HSSFWorkbook
extends POIDocument {
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = 3;
    private Workbook workbook;
    protected List _sheets;
    private ArrayList names;
    private boolean preserveNodes;
    private HSSFDataFormat formatter;
    private HSSFRow.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFWorkbook == null ? (class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFWorkbook = HSSFWorkbook.class$("com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook")) : class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFWorkbook);
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};
    public static final byte ENCODING_COMPRESSED_UNICODE = 0;
    public static final byte ENCODING_UTF_16 = 1;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFWorkbook;

    public HSSFWorkbook() {
        this(Workbook.createWorkbook());
    }

    protected HSSFWorkbook(Workbook workbook) {
        super(null, null);
        this.workbook = workbook;
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem, true);
    }

    public HSSFWorkbook(POIFSFileSystem pOIFSFileSystem, boolean bl) throws IOException {
        this(pOIFSFileSystem.getRoot(), pOIFSFileSystem, bl);
    }

    private static String getWorkbookDirEntryName(DirectoryNode directoryNode) {
        String[] stringArray = WORKBOOK_DIR_ENTRY_NAMES;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                directoryNode.getEntry(string);
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
        }
        try {
            directoryNode.getEntry("Book");
            throw new IllegalArgumentException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    public HSSFWorkbook(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem, boolean bl) throws IOException {
        super(directoryNode, pOIFSFileSystem);
        Object object;
        Sheet sheet;
        String string = HSSFWorkbook.getWorkbookDirEntryName(directoryNode);
        this.preserveNodes = bl;
        if (!bl) {
            this.filesystem = null;
            this.directory = null;
        }
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream(string);
        EventRecordFactory eventRecordFactory = new EventRecordFactory();
        List list = RecordFactory.createRecords(documentInputStream);
        this.workbook = Workbook.createWorkbook(list);
        this.setPropertiesFromWorkbook(this.workbook);
        int n = this.workbook.getNumRecords();
        int n2 = 0;
        this.convertLabelRecords(list, n);
        while (n < list.size() && (n = (sheet = Sheet.createSheet(list, n2++, n)).getEofLoc() + 1) != 1) {
            object = new HSSFSheet(this, sheet);
            this._sheets.add(object);
        }
        for (int i = 0; i < this.workbook.getNumNames(); ++i) {
            object = new HSSFName(this, this.workbook.getNameRecord(i));
            this.names.add(object);
        }
    }

    public HSSFWorkbook(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public HSSFWorkbook(InputStream inputStream, boolean bl) throws IOException {
        this(new POIFSFileSystem(inputStream), bl);
    }

    private void setPropertiesFromWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    private void convertLabelRecords(List list, int n) {
        if (log.check(1)) {
            log.log(1, "convertLabelRecords called");
        }
        for (int i = n; i < list.size(); ++i) {
            Record record = (Record)list.get(i);
            if (record.getSid() != 516) continue;
            LabelRecord labelRecord = (LabelRecord)record;
            list.remove(i);
            LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
            int n2 = this.workbook.addSSTString(new UnicodeString(labelRecord.getValue()));
            labelSSTRecord.setRow(labelRecord.getRow());
            labelSSTRecord.setColumn(labelRecord.getColumn());
            labelSSTRecord.setXFIndex(labelRecord.getXFIndex());
            labelSSTRecord.setSSTIndex(n2);
            list.add(i, labelSSTRecord);
        }
        if (log.check(1)) {
            log.log(1, "convertLabelRecords exit");
        }
    }

    public HSSFRow.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    public void setMissingCellPolicy(HSSFRow.MissingCellPolicy missingCellPolicy) {
        this.missingCellPolicy = missingCellPolicy;
    }

    public void setSheetOrder(String string, int n) {
        this._sheets.add(n, this._sheets.remove(this.getSheetIndex(string)));
        this.workbook.setSheetOrder(string, n);
    }

    private void validateSheetIndex(int n) {
        int n2 = this._sheets.size() - 1;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Sheet index (" + n + ") is out of range (0.." + n2 + ")");
        }
    }

    public void setSelectedTab(int n) {
        this.validateSheetIndex(n);
        int n2 = this._sheets.size();
        for (int i = 0; i < n2; ++i) {
            this.getSheetAt(i).setSelected(i == n);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)1);
    }

    public void setSelectedTab(short s) {
        this.setSelectedTab((int)s);
    }

    public void setSelectedTabs(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            this.validateSheetIndex(nArray[n]);
        }
        n = this._sheets.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != i) continue;
                bl = true;
                break;
            }
            this.getSheetAt(i).setSelected(bl);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)nArray.length);
    }

    public void setActiveSheet(int n) {
        this.validateSheetIndex(n);
        int n2 = this._sheets.size();
        for (int i = 0; i < n2; ++i) {
            this.getSheetAt(i).setActive(i == n);
        }
        this.workbook.getWindowOne().setActiveSheetIndex(n);
    }

    public int getActiveSheetIndex() {
        return this.workbook.getWindowOne().getActiveSheetIndex();
    }

    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    public void setFirstVisibleTab(int n) {
        this.workbook.getWindowOne().setFirstVisibleTab(n);
    }

    public void setDisplayedTab(short s) {
        this.setFirstVisibleTab(s);
    }

    public int getFirstVisibleTab() {
        return this.workbook.getWindowOne().getFirstVisibleTab();
    }

    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    public void setSheetName(int n, String string) {
        if (this.workbook.doesContainsSheetName(string, n)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(n);
        this.workbook.setSheetName(n, string);
    }

    public void setSheetName(int n, String string, short s) {
        if (this.workbook.doesContainsSheetName(string, n)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(n);
        switch (s) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported encoding");
            }
        }
        this.workbook.setSheetName(n, string, s);
    }

    public String getSheetName(int n) {
        this.validateSheetIndex(n);
        return this.workbook.getSheetName(n);
    }

    public boolean isSheetHidden(int n) {
        this.validateSheetIndex(n);
        return this.workbook.isSheetHidden(n);
    }

    public void setSheetHidden(int n, boolean bl) {
        this.validateSheetIndex(n);
        this.workbook.setSheetHidden(n, bl);
    }

    public int getSheetIndex(String string) {
        int n = this.workbook.getSheetIndex(string);
        return n;
    }

    public int getSheetIndex(HSSFSheet hSSFSheet) {
        for (int i = 0; i < this._sheets.size(); ++i) {
            if (this._sheets.get(i) != hSSFSheet) continue;
            return i;
        }
        return -1;
    }

    public short getExternalSheetIndex(int n) {
        return this.workbook.checkExternSheet(n);
    }

    public HSSFSheet createSheet() {
        HSSFSheet hSSFSheet = new HSSFSheet(this);
        this._sheets.add(hSSFSheet);
        this.workbook.setSheetName(this._sheets.size() - 1, "Sheet" + (this._sheets.size() - 1));
        boolean bl = this._sheets.size() == 1;
        hSSFSheet.setSelected(bl);
        hSSFSheet.setActive(bl);
        return hSSFSheet;
    }

    public HSSFSheet cloneSheet(int n) {
        String string;
        String string2;
        this.validateSheetIndex(n);
        HSSFSheet hSSFSheet = (HSSFSheet)this._sheets.get(n);
        String string3 = this.workbook.getSheetName(n);
        HSSFSheet hSSFSheet2 = hSSFSheet.cloneSheet(this);
        hSSFSheet2.setSelected(false);
        hSSFSheet2.setActive(false);
        this._sheets.add(hSSFSheet2);
        int n2 = 1;
        do {
            string2 = string3;
            string = Integer.toString(n2++);
        } while (this.workbook.getSheetIndex(string2 = string2.length() + string.length() + 2 < 31 ? string2 + "(" + string + ")" : string2.substring(0, 31 - string.length() - 2) + "(" + string + ")") != -1);
        this.workbook.setSheetName(this._sheets.size() - 1, string2);
        return hSSFSheet2;
    }

    public HSSFSheet createSheet(String string) {
        if (this.workbook.doesContainsSheetName(string, this._sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet hSSFSheet = new HSSFSheet(this);
        this._sheets.add(hSSFSheet);
        this.workbook.setSheetName(this._sheets.size() - 1, string);
        boolean bl = this._sheets.size() == 1;
        hSSFSheet.setSelected(bl);
        hSSFSheet.setActive(bl);
        return hSSFSheet;
    }

    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    private HSSFSheet[] getSheets() {
        HSSFSheet[] hSSFSheetArray = new HSSFSheet[this._sheets.size()];
        this._sheets.toArray(hSSFSheetArray);
        return hSSFSheetArray;
    }

    public HSSFSheet getSheetAt(int n) {
        return (HSSFSheet)this._sheets.get(n);
    }

    public HSSFSheet getSheet(String string) {
        HSSFSheet hSSFSheet = null;
        for (int i = 0; i < this._sheets.size(); ++i) {
            String string2 = this.workbook.getSheetName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            hSSFSheet = (HSSFSheet)this._sheets.get(i);
        }
        return hSSFSheet;
    }

    public SheetReferences getSheetReferences() {
        return this.workbook.getSheetReferences();
    }

    public void removeSheetAt(int n) {
        this.validateSheetIndex(n);
        boolean bl = this.getSheetAt(n).isActive();
        boolean bl2 = this.getSheetAt(n).isSelected();
        this._sheets.remove(n);
        this.workbook.removeSheet(n);
        int n2 = this._sheets.size();
        if (n2 < 1) {
            return;
        }
        int n3 = n;
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        if (bl) {
            this.setActiveSheet(n3);
        }
        if (bl2) {
            boolean bl3 = false;
            for (int i = 0; i < n2; ++i) {
                if (!this.getSheetAt(i).isSelected()) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.setSelectedTab(n3);
            }
        }
    }

    public void setBackupFlag(boolean bl) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(bl ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    public void setRepeatingRowsAndColumns(int n, int n2, int n3, int n4, int n5) {
        Object object;
        if (n2 == -1 && n3 != -1) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (n4 == -1 && n5 != -1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (n2 < -1 || n2 >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (n3 < -1 || n3 >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (n4 < -1 || n4 > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (n5 < -1 || n5 > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (n4 > n5) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        HSSFSheet hSSFSheet = this.getSheetAt(n);
        short s = this.getWorkbook().checkExternSheet(n);
        boolean bl = n2 != -1 && n3 != -1 && n4 != -1 && n5 != -1;
        boolean bl2 = n2 == -1 && n3 == -1 && n4 == -1 && n5 == -1;
        boolean bl3 = false;
        NameRecord nameRecord = this.findExistingRowColHeaderNameRecord(n);
        if (bl2) {
            if (nameRecord != null) {
                this.workbook.removeName(this.findExistingRowColHeaderNameRecordIdx(n + 1));
            }
            return;
        }
        if (nameRecord == null) {
            nameRecord = this.workbook.createBuiltInName((byte)7, n + 1);
            bl3 = true;
        }
        short s2 = bl ? (short)26 : 11;
        nameRecord.setDefinitionTextLength(s2);
        Stack<Object> stack = new Stack<Object>();
        if (bl) {
            stack.add(new MemFuncPtg(23));
        }
        if (n2 >= 0) {
            object = new Area3DPtg();
            ((Area3DPtg)object).setExternSheetIndex(s);
            ((Area3DPtg)object).setFirstColumn((short)n2);
            ((Area3DPtg)object).setLastColumn((short)n3);
            ((Area3DPtg)object).setFirstRow(0);
            ((Area3DPtg)object).setLastRow(-1);
            stack.add(object);
        }
        if (n4 >= 0) {
            object = new Area3DPtg();
            ((Area3DPtg)object).setExternSheetIndex(s);
            ((Area3DPtg)object).setFirstColumn((short)0);
            ((Area3DPtg)object).setLastColumn((short)255);
            ((Area3DPtg)object).setFirstRow((short)n4);
            ((Area3DPtg)object).setLastRow((short)n5);
            stack.add(object);
        }
        if (bl) {
            stack.add(UnionPtg.instance);
        }
        nameRecord.setNameDefinition(stack);
        if (bl3) {
            object = new HSSFName(this, nameRecord);
            this.names.add(object);
        }
        object = hSSFSheet.getPrintSetup();
        ((HSSFPrintSetup)object).setValidSettings(false);
        hSSFSheet.setActive(true);
    }

    private NameRecord findExistingRowColHeaderNameRecord(int n) {
        int n2 = this.findExistingRowColHeaderNameRecordIdx(n);
        if (n2 == -1) {
            return null;
        }
        return (NameRecord)this.workbook.findNextRecordBySid((short)24, n2);
    }

    private int findExistingRowColHeaderNameRecordIdx(int n) {
        int n2 = 0;
        NameRecord nameRecord = null;
        while ((nameRecord = (NameRecord)this.workbook.findNextRecordBySid((short)24, n2)) != null) {
            int n3 = nameRecord.getEqualsToIndexToSheet() - 1;
            if (n3 > -1) {
                int n4 = this.workbook.getSheetIndexFromExternSheetIndex(n3);
                if (this.isRowColHeaderRecord(nameRecord) && n4 == n) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    private boolean isRowColHeaderRecord(NameRecord nameRecord) {
        return nameRecord.getOptionFlag() == 32 && "\u0007".equals(nameRecord.getNameText());
    }

    public HSSFFont createFont() {
        FontRecord fontRecord = this.workbook.createNewFont();
        short s = (short)(this.getNumberOfFonts() - 1);
        if (s > 3) {
            s = (short)(s + 1);
        }
        if (s == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of fonts was exceeded");
        }
        HSSFFont hSSFFont = new HSSFFont(s, fontRecord);
        return hSSFFont;
    }

    public HSSFFont findFont(short s, short s2, short s3, String string, boolean bl, boolean bl2, short s4, byte by) {
        for (short s5 = 0; s5 < this.workbook.getNumberOfFontRecords(); s5 = (short)((short)(s5 + 1))) {
            FontRecord fontRecord;
            HSSFFont hSSFFont;
            if (s5 == 4 || (hSSFFont = new HSSFFont(s5, fontRecord = this.workbook.getFontRecordAt(s5))).getBoldweight() != s || hSSFFont.getColor() != s2 || hSSFFont.getFontHeight() != s3 || !hSSFFont.getFontName().equals(string) || hSSFFont.getItalic() != bl || hSSFFont.getStrikeout() != bl2 || hSSFFont.getTypeOffset() != s4 || hSSFFont.getUnderline() != by) continue;
            return hSSFFont;
        }
        return null;
    }

    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    public HSSFFont getFontAt(short s) {
        FontRecord fontRecord = this.workbook.getFontRecordAt(s);
        HSSFFont hSSFFont = new HSSFFont(s, fontRecord);
        return hSSFFont;
    }

    public HSSFCellStyle createCellStyle() {
        ExtendedFormatRecord extendedFormatRecord = this.workbook.createCellXF();
        short s = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle hSSFCellStyle = new HSSFCellStyle(s, extendedFormatRecord, this);
        return hSSFCellStyle;
    }

    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    public HSSFCellStyle getCellStyleAt(short s) {
        ExtendedFormatRecord extendedFormatRecord = this.workbook.getExFormatAt(s);
        HSSFCellStyle hSSFCellStyle = new HSSFCellStyle(s, extendedFormatRecord, this);
        return hSSFCellStyle;
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBytes();
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem();
        if (this.workbook.getFilePassRecord() != null) {
            PWDUtils.encrypt(byArray, this.workbook.getFilePassRecord());
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        pOIFSFileSystem.createDocument(new ByteArrayInputStream(byArray), "Workbook");
        this.writeProperties(pOIFSFileSystem, arrayList);
        if (this.preserveNodes) {
            arrayList.add("Workbook");
            arrayList.add("WORKBOOK");
            this.copyNodes(this.filesystem, pOIFSFileSystem, arrayList);
        }
        pOIFSFileSystem.writeFilesystem(outputStream);
    }

    public byte[] getBytes() {
        int n;
        int n2;
        if (log.check(1)) {
            log.log(1, "HSSFWorkbook.getBytes()");
        }
        HSSFSheet[] hSSFSheetArray = this.getSheets();
        int n3 = hSSFSheetArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            hSSFSheetArray[n2].getSheet().preSerialize();
        }
        n2 = this.workbook.getSize();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.workbook.setSheetBof(i, n2);
            nArray[i] = n = hSSFSheetArray[i].getSheet().getSize();
            n2 += n;
        }
        byte[] byArray = new byte[n2];
        n = this.workbook.serialize(0, byArray);
        for (int i = 0; i < n3; ++i) {
            int n4 = hSSFSheetArray[i].getSheet().serialize(n, byArray);
            if (n4 != nArray[i]) {
                throw new IllegalStateException("Actual serialized sheet size (" + n4 + ") differs from pre-calculated size (" + nArray[i] + ") for sheet (" + i + ")");
            }
            n += n4;
        }
        return byArray;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    public String getSSTString(int n) {
        return this.workbook.getSSTString(n).getString();
    }

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    public int getNumberOfNames() {
        int n = this.names.size();
        return n;
    }

    public HSSFName getNameAt(int n) {
        HSSFName hSSFName = (HSSFName)this.names.get(n);
        return hSSFName;
    }

    public String getNameName(int n) {
        String string = this.getNameAt(n).getNameName();
        return string;
    }

    public String resolveNameXText(int n, int n2) {
        return this.workbook.resolveNameXText(n, n2);
    }

    public void setPrintArea(int n, String string) {
        NameRecord nameRecord = this.workbook.getSpecificBuiltinRecord((byte)6, n + 1);
        if (nameRecord == null) {
            nameRecord = this.workbook.createBuiltInName((byte)6, n + 1);
        }
        short s = this.getWorkbook().checkExternSheet(n);
        nameRecord.setExternSheetNumber(s);
        nameRecord.setAreaReference(string);
    }

    public void setPrintArea(int n, int n2, int n3, int n4, int n5) {
        CellReference cellReference = new CellReference(n4, n2, true, true);
        String string = cellReference.formatAsString();
        cellReference = new CellReference(n5, n3, true, true);
        string = string + ":" + cellReference.formatAsString();
        this.setPrintArea(n, string);
    }

    public String getPrintArea(int n) {
        NameRecord nameRecord = this.workbook.getSpecificBuiltinRecord((byte)6, n + 1);
        if (nameRecord == null) {
            return null;
        }
        return nameRecord.getAreaReference(this);
    }

    public void removePrintArea(int n) {
        this.getWorkbook().removeBuiltinRecord((byte)6, n + 1);
    }

    public HSSFName createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName hSSFName = new HSSFName(this, nameRecord);
        this.names.add(hSSFName);
        return hSSFName;
    }

    public int getNameIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.names.size(); ++i) {
            String string2 = this.getNameName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void removeName(int n) {
        this.names.remove(n);
        this.workbook.removeName(n);
    }

    public HSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    public void removeName(String string) {
        int n = this.getNameIndex(string);
        this.removeName(n);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    public void insertChartRecord() {
        int n = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] byArray = new byte[]{15, 0, 0, -16, 82, 0, 0, 0, 0, 0, 6, -16, 24, 0, 0, 0, 1, 8, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 51, 0, 11, -16, 18, 0, 0, 0, -65, 0, 8, 0, 8, 0, -127, 1, 9, 0, 0, 8, -64, 1, 64, 0, 0, 8, 64, 0, 30, -15, 16, 0, 0, 0, 13, 0, 0, 8, 12, 0, 0, 8, 23, 0, 0, 8, -9, 0, 0, 16};
        UnknownRecord unknownRecord = new UnknownRecord(235, byArray);
        this.workbook.getRecords().add(n, unknownRecord);
    }

    public void dumpDrawingGroupRecords(boolean bl) {
        DrawingGroupRecord drawingGroupRecord = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        drawingGroupRecord.decode();
        List list = drawingGroupRecord.getEscherRecords();
        PrintWriter printWriter = new PrintWriter(System.out);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (bl) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(printWriter, 0);
        }
        printWriter.flush();
    }

    public int addPicture(byte[] byArray, int n) {
        byte[] byArray2 = this.newUID();
        EscherBitmapBlip escherBitmapBlip = new EscherBitmapBlip();
        escherBitmapBlip.setRecordId((short)(-4072 + n));
        switch (n) {
            case 2: {
                escherBitmapBlip.setOptions((short)15680);
                break;
            }
            case 3: {
                escherBitmapBlip.setOptions((short)8544);
                break;
            }
            case 4: {
                escherBitmapBlip.setOptions((short)21536);
                break;
            }
            case 6: {
                escherBitmapBlip.setOptions((short)28160);
                break;
            }
            case 5: {
                escherBitmapBlip.setOptions((short)18080);
                break;
            }
            case 7: {
                escherBitmapBlip.setOptions((short)31360);
            }
        }
        escherBitmapBlip.setUID(byArray2);
        escherBitmapBlip.setMarker((byte)-1);
        escherBitmapBlip.setPictureData(byArray);
        EscherBSERecord escherBSERecord = new EscherBSERecord();
        escherBSERecord.setRecordId((short)-4089);
        escherBSERecord.setOptions((short)(2 | n << 4));
        escherBSERecord.setBlipTypeMacOS((byte)n);
        escherBSERecord.setBlipTypeWin32((byte)n);
        escherBSERecord.setUid(byArray2);
        escherBSERecord.setTag((short)255);
        escherBSERecord.setSize(byArray.length + 25);
        escherBSERecord.setRef(1);
        escherBSERecord.setOffset(0);
        escherBSERecord.setBlipRecord(escherBitmapBlip);
        return this.workbook.addBSERecord(escherBSERecord);
    }

    public List getAllPictures() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.workbook.getRecords().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)e).decode();
            List list = ((AbstractEscherHolderRecord)e).getEscherRecords();
            this.searchForPictures(list, arrayList);
        }
        return arrayList;
    }

    private void searchForPictures(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EscherBlipRecord escherBlipRecord;
            Object e = iterator.next();
            if (!(e instanceof EscherRecord)) continue;
            EscherRecord escherRecord = (EscherRecord)e;
            if (escherRecord instanceof EscherBSERecord && (escherBlipRecord = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                list2.add(new HSSFPictureData(escherBlipRecord));
            }
            this.searchForPictures(escherRecord.getChildRecords(), list2);
        }
    }

    public boolean isWriteProtected() {
        return this.workbook.isWriteProtected();
    }

    public void writeProtectWorkbook(String string, String string2) {
        this.workbook.writeProtectWorkbook(string, string2);
    }

    public void unwriteProtectWorkbook() {
        this.workbook.unwriteProtectWorkbook();
    }

    public List getAllEmbeddedObjects() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            this.getAllEmbeddedObjects(this.getSheetAt(i).getSheet().getRecords(), arrayList);
        }
        return arrayList;
    }

    private void getAllEmbeddedObjects(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ObjRecord)) continue;
            Iterator iterator2 = ((ObjRecord)e).getSubRecords().iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof EmbeddedObjectRefSubRecord)) continue;
                list2.add(new HSSFObjectData((ObjRecord)e, this.filesystem));
            }
        }
    }

    private byte[] newUID() {
        byte[] byArray = new byte[16];
        return byArray;
    }

    public void setFilePassword(String string) {
        this.workbook.setFilePassword(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

