/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.record.CFRuleRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFConditionalFormatting;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.Region;

public final class HSSFSheetConditionalFormatting {
    private final HSSFWorkbook _workbook;
    private final Sheet _sheet;

    HSSFSheetConditionalFormatting(HSSFWorkbook hSSFWorkbook, Sheet sheet) {
        this._workbook = hSSFWorkbook;
        this._sheet = sheet;
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(byte by, String string, String string2) {
        HSSFWorkbook hSSFWorkbook = this._workbook;
        CFRuleRecord cFRuleRecord = CFRuleRecord.create(hSSFWorkbook, by, string, string2);
        return new HSSFConditionalFormattingRule(hSSFWorkbook, cFRuleRecord);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(String string) {
        HSSFWorkbook hSSFWorkbook = this._workbook;
        CFRuleRecord cFRuleRecord = CFRuleRecord.create(hSSFWorkbook, string);
        return new HSSFConditionalFormattingRule(hSSFWorkbook, cFRuleRecord);
    }

    public int addConditionalFormatting(HSSFConditionalFormatting hSSFConditionalFormatting) {
        CFRecordsAggregate cFRecordsAggregate = hSSFConditionalFormatting.getCFRecordsAggregate().cloneCFAggregate();
        return this._sheet.addConditionalFormatting(cFRecordsAggregate);
    }

    public int addConditionalFormatting(Region[] regionArray, HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray) {
        if (regionArray == null) {
            throw new IllegalArgumentException("regions must not be null");
        }
        if (hSSFConditionalFormattingRuleArray == null) {
            throw new IllegalArgumentException("cfRules must not be null");
        }
        if (hSSFConditionalFormattingRuleArray.length == 0) {
            throw new IllegalArgumentException("cfRules must not be empty");
        }
        if (hSSFConditionalFormattingRuleArray.length > 3) {
            throw new IllegalArgumentException("Number of rules must not exceed 3");
        }
        CFRuleRecord[] cFRuleRecordArray = new CFRuleRecord[hSSFConditionalFormattingRuleArray.length];
        for (int i = 0; i != hSSFConditionalFormattingRuleArray.length; ++i) {
            cFRuleRecordArray[i] = hSSFConditionalFormattingRuleArray[i].getCfRuleRecord();
        }
        CFRecordsAggregate cFRecordsAggregate = new CFRecordsAggregate(regionArray, cFRuleRecordArray);
        return this._sheet.addConditionalFormatting(cFRecordsAggregate);
    }

    public int addConditionalFormatting(Region[] regionArray, HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        return this.addConditionalFormatting(regionArray, new HSSFConditionalFormattingRule[]{hSSFConditionalFormattingRule});
    }

    public int addConditionalFormatting(Region[] regionArray, HSSFConditionalFormattingRule hSSFConditionalFormattingRule, HSSFConditionalFormattingRule hSSFConditionalFormattingRule2) {
        return this.addConditionalFormatting(regionArray, new HSSFConditionalFormattingRule[]{hSSFConditionalFormattingRule, hSSFConditionalFormattingRule2});
    }

    public int addConditionalFormatting(Region[] regionArray, HSSFConditionalFormattingRule hSSFConditionalFormattingRule, HSSFConditionalFormattingRule hSSFConditionalFormattingRule2, HSSFConditionalFormattingRule hSSFConditionalFormattingRule3) {
        return this.addConditionalFormatting(regionArray, new HSSFConditionalFormattingRule[]{hSSFConditionalFormattingRule, hSSFConditionalFormattingRule2, hSSFConditionalFormattingRule3});
    }

    public HSSFConditionalFormatting getConditionalFormattingAt(int n) {
        CFRecordsAggregate cFRecordsAggregate = this._sheet.getCFRecordsAggregateAt(n);
        if (cFRecordsAggregate == null) {
            return null;
        }
        return new HSSFConditionalFormatting(this._workbook, cFRecordsAggregate);
    }

    public int getNumConditionalFormattings() {
        return this._sheet.getNumConditionalFormattings();
    }

    public void removeConditionalFormatting(int n) {
        this._sheet.removeConditionalFormatting(n);
    }
}

