/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.DVALRecord;
import com.fr.third.org.apache.poi.hssf.record.DVRecord;
import com.fr.third.org.apache.poi.hssf.record.EscherAggregate;
import com.fr.third.org.apache.poi.hssf.record.HCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.PageBreakRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.org.apache.poi.hssf.record.SCLRecord;
import com.fr.third.org.apache.poi.hssf.record.VCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.WSBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFooter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFHeader;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFCellRangeAddress;
import com.fr.third.org.apache.poi.hssf.util.HSSFDataValidation;
import com.fr.third.org.apache.poi.hssf.util.PaneInformation;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;

public final class HSSFSheet {
    private static final int DEBUG = 1;
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;
    public static final int INITIAL_CAPACITY = 20;
    private Sheet sheet;
    private TreeMap rows;
    protected Workbook book;
    protected HSSFWorkbook workbook;
    private int firstrow;
    private int lastrow;
    private static POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFSheet == null ? (class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFSheet = HSSFSheet.class$("com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet")) : class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFSheet);
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFSheet;

    protected HSSFSheet(HSSFWorkbook hSSFWorkbook) {
        this.sheet = Sheet.createSheet();
        this.rows = new TreeMap();
        this.workbook = hSSFWorkbook;
        this.book = hSSFWorkbook.getWorkbook();
    }

    protected HSSFSheet(HSSFWorkbook hSSFWorkbook, Sheet sheet) {
        this.sheet = sheet;
        this.rows = new TreeMap();
        this.workbook = hSSFWorkbook;
        this.book = hSSFWorkbook.getWorkbook();
        this.setPropertiesFromSheet(sheet);
    }

    HSSFSheet cloneSheet(HSSFWorkbook hSSFWorkbook) {
        return new HSSFSheet(hSSFWorkbook, this.sheet.cloneSheet());
    }

    private void setPropertiesFromSheet(Sheet sheet) {
        boolean bl;
        int n = sheet.getLoc();
        RowRecord rowRecord = sheet.getNextRow();
        boolean bl2 = bl = rowRecord != null;
        while (rowRecord != null) {
            this.createRowFromRecord(rowRecord);
            rowRecord = sheet.getNextRow();
        }
        sheet.setLoc(n);
        CellValueRecordInterface cellValueRecordInterface = sheet.getNextValueRecord();
        long l = System.currentTimeMillis();
        if (log.check(1)) {
            log.log(1, (Object)"Time at start of cell creating in HSSF sheet = ", new Long(l));
        }
        HSSFRow hSSFRow = null;
        while (cellValueRecordInterface != null) {
            long l2 = System.currentTimeMillis();
            HSSFRow hSSFRow2 = hSSFRow;
            if ((hSSFRow == null || hSSFRow.getRowNum() != cellValueRecordInterface.getRow()) && (hSSFRow2 = this.getRow(cellValueRecordInterface.getRow())) == null) {
                if (bl) {
                    throw new RuntimeException("Unexpected missing row when some rows already present");
                }
                RowRecord rowRecord2 = new RowRecord(cellValueRecordInterface.getRow());
                sheet.addRow(rowRecord2);
                hSSFRow2 = this.createRowFromRecord(rowRecord2);
            }
            if (hSSFRow2 != null) {
                hSSFRow = hSSFRow2;
                if (log.check(1)) {
                    log.log(1, "record id = " + Integer.toHexString(((Record)((Object)cellValueRecordInterface)).getSid()));
                }
                hSSFRow2.createCellFromRecord(cellValueRecordInterface);
                cellValueRecordInterface = sheet.getNextValueRecord();
                if (!log.check(1)) continue;
                log.log(1, (Object)"record took ", new Long(System.currentTimeMillis() - l2));
                continue;
            }
            cellValueRecordInterface = null;
        }
        if (log.check(1)) {
            log.log(1, (Object)"total sheet cell creation took ", new Long(System.currentTimeMillis() - l));
        }
    }

    public HSSFRow createRow(int n) {
        HSSFRow hSSFRow = new HSSFRow(this.workbook, this.sheet, n);
        this.addRow(hSSFRow, true);
        return hSSFRow;
    }

    private HSSFRow createRowFromRecord(RowRecord rowRecord) {
        HSSFRow hSSFRow = new HSSFRow(this.workbook, this.sheet, rowRecord);
        this.addRow(hSSFRow, false);
        return hSSFRow;
    }

    public void removeRow(HSSFRow hSSFRow) {
        this.sheet.setLoc(this.sheet.getDimsLoc());
        if (this.rows.size() > 0) {
            this.rows.remove(hSSFRow);
            if (hSSFRow.getRowNum() == this.getLastRowNum()) {
                this.lastrow = this.findLastRow(this.lastrow);
            }
            if (hSSFRow.getRowNum() == this.getFirstRowNum()) {
                this.firstrow = this.findFirstRow(this.firstrow);
            }
            Iterator iterator = hSSFRow.cellIterator();
            while (iterator.hasNext()) {
                HSSFCell hSSFCell = (HSSFCell)iterator.next();
                this.sheet.removeValueRecord(hSSFRow.getRowNum(), hSSFCell.getCellValueRecord());
            }
            this.sheet.removeRow(hSSFRow.getRowRecord());
        }
    }

    private int findLastRow(int n) {
        int n2 = n - 1;
        HSSFRow hSSFRow = this.getRow(n2);
        while (hSSFRow == null && n2 > 0) {
            hSSFRow = this.getRow(--n2);
        }
        if (hSSFRow == null) {
            return -1;
        }
        return n2;
    }

    private int findFirstRow(int n) {
        int n2 = n + 1;
        HSSFRow hSSFRow = this.getRow(n2);
        while (hSSFRow == null && n2 <= this.getLastRowNum()) {
            hSSFRow = this.getRow(++n2);
        }
        if (n2 > this.getLastRowNum()) {
            return -1;
        }
        return n2;
    }

    private void addRow(HSSFRow hSSFRow, boolean bl) {
        this.rows.put(hSSFRow, hSSFRow);
        if (bl) {
            this.sheet.addRow(hSSFRow.getRowRecord());
        }
        if (hSSFRow.getRowNum() > this.getLastRowNum()) {
            this.lastrow = hSSFRow.getRowNum();
        }
        if (hSSFRow.getRowNum() < this.getFirstRowNum()) {
            this.firstrow = hSSFRow.getRowNum();
        }
    }

    public HSSFRow getRow(int n) {
        HSSFRow hSSFRow = new HSSFRow();
        hSSFRow.setRowNum(n);
        return (HSSFRow)this.rows.get(hSSFRow);
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public void addValidationData(HSSFDataValidation hSSFDataValidation) {
        int n;
        if (hSSFDataValidation == null) {
            return;
        }
        DVALRecord dVALRecord = (DVALRecord)this.sheet.findFirstRecordBySid((short)434);
        int n2 = this.sheet.findFirstRecordLocBySid((short)10);
        if (dVALRecord == null) {
            dVALRecord = new DVALRecord();
            this.sheet.getRecords().add(n2, dVALRecord);
        }
        int n3 = dVALRecord.getDVRecNo();
        dVALRecord.setDVRecNo(n3 + 1);
        DVRecord dVRecord = new DVRecord();
        dVRecord.setDataType(hSSFDataValidation.getDataValidationType());
        dVRecord.setErrorStyle(hSSFDataValidation.getErrorStyle());
        dVRecord.setEmptyCellAllowed(hSSFDataValidation.getEmptyCellAllowed());
        dVRecord.setSurppresDropdownArrow(hSSFDataValidation.getSurppressDropDownArrow());
        dVRecord.setShowPromptOnCellSelected(hSSFDataValidation.getShowPromptBox());
        dVRecord.setShowErrorOnInvalidValue(hSSFDataValidation.getShowErrorBox());
        dVRecord.setConditionOperator(hSSFDataValidation.getOperator());
        dVRecord.setStringField(DVRecord.STRING_PROMPT_TITLE, hSSFDataValidation.getPromptBoxTitle());
        dVRecord.setStringField(DVRecord.STRING_PROMPT_TEXT, hSSFDataValidation.getPromptBoxText());
        dVRecord.setStringField(DVRecord.STRING_ERROR_TITLE, hSSFDataValidation.getErrorBoxTitle());
        dVRecord.setStringField(DVRecord.STRING_ERROR_TEXT, hSSFDataValidation.getErrorBoxText());
        String string = hSSFDataValidation.getFirstFormula();
        FormulaParser formulaParser = new FormulaParser(string, this.workbook);
        formulaParser.parse();
        Stack<Ptg> stack = new Stack<Ptg>();
        Ptg[] ptgArray = formulaParser.getRPNPtg();
        int n4 = 0;
        for (n = 0; n < ptgArray.length; ++n) {
            if (ptgArray[n] instanceof AreaPtg) {
                ptgArray[n].setClass((byte)0);
                hSSFDataValidation.setExplicitListFormula(false);
            }
            n4 += ptgArray[n].getSize();
            stack.push(ptgArray[n]);
        }
        dVRecord.setFirstFormulaRPN(stack);
        dVRecord.setFirstFormulaSize((short)n4);
        dVRecord.setListExplicitFormula(hSSFDataValidation.getExplicitListFormula());
        if (hSSFDataValidation.getSecondFormula() != null) {
            string = hSSFDataValidation.getSecondFormula();
            formulaParser = new FormulaParser(string, this.workbook);
            formulaParser.parse();
            stack = new Stack();
            ptgArray = formulaParser.getRPNPtg();
            n4 = 0;
            for (n = 0; n < ptgArray.length; ++n) {
                n4 += ptgArray[n].getSize();
                stack.push(ptgArray[n]);
            }
            dVRecord.setSecFormulaRPN(stack);
            dVRecord.setSecFormulaSize((short)n4);
        }
        HSSFCellRangeAddress hSSFCellRangeAddress = new HSSFCellRangeAddress();
        hSSFCellRangeAddress.addADDRStructure(hSSFDataValidation.getFirstRow(), hSSFDataValidation.getFirstColumn(), hSSFDataValidation.getLastRow(), hSSFDataValidation.getLastColumn());
        dVRecord.setCellRangeAddress(hSSFCellRangeAddress);
        n2 = this.sheet.findFirstRecordLocBySid((short)10);
        this.sheet.getRecords().add(n2, dVRecord);
    }

    public void setColumnHidden(short s, boolean bl) {
        this.sheet.setColumnHidden(s, bl);
    }

    public boolean isColumnHidden(short s) {
        return this.sheet.isColumnHidden(s);
    }

    public void setColumnWidth(short s, short s2) {
        this.sheet.setColumnWidth(s, s2);
    }

    public short getColumnWidth(short s) {
        return this.sheet.getColumnWidth(s);
    }

    public short getDefaultColumnWidth() {
        return this.sheet.getDefaultColumnWidth();
    }

    public short getDefaultRowHeight() {
        return this.sheet.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return this.sheet.getDefaultRowHeight() / 20;
    }

    public void setDefaultColumnWidth(short s) {
        this.sheet.setDefaultColumnWidth(s);
    }

    public void setDefaultRowHeight(short s) {
        this.sheet.setDefaultRowHeight(s);
    }

    public void setDefaultRowHeightInPoints(float f) {
        this.sheet.setDefaultRowHeight((short)(f * 20.0f));
    }

    public boolean isGridsPrinted() {
        return this.sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean bl) {
        this.sheet.setGridsPrinted(bl);
    }

    public int addMergedRegion(Region region) {
        return this.sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    public void setForceFormulaRecalculation(boolean bl) {
        this.sheet.setUncalced(bl);
    }

    public boolean getForceFormulaRecalculation() {
        return this.sheet.getUncalced();
    }

    public void setVerticallyCenter(boolean bl) {
        VCenterRecord vCenterRecord = (VCenterRecord)this.sheet.findFirstRecordBySid((short)132);
        vCenterRecord.setVCenter(bl);
    }

    public boolean getVerticallyCenter(boolean bl) {
        return this.getVerticallyCenter();
    }

    public boolean getVerticallyCenter() {
        VCenterRecord vCenterRecord = (VCenterRecord)this.sheet.findFirstRecordBySid((short)132);
        return vCenterRecord.getVCenter();
    }

    public void setHorizontallyCenter(boolean bl) {
        HCenterRecord hCenterRecord = (HCenterRecord)this.sheet.findFirstRecordBySid((short)131);
        hCenterRecord.setHCenter(bl);
    }

    public boolean getHorizontallyCenter() {
        HCenterRecord hCenterRecord = (HCenterRecord)this.sheet.findFirstRecordBySid((short)131);
        return hCenterRecord.getHCenter();
    }

    public void removeMergedRegion(int n) {
        this.sheet.removeMergedRegion(n);
    }

    public int getNumMergedRegions() {
        return this.sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int n) {
        return new Region(this.sheet.getMergedRegionAt(n));
    }

    public Iterator rowIterator() {
        return this.rows.values().iterator();
    }

    public Iterator iterator() {
        return this.rowIterator();
    }

    protected Sheet getSheet() {
        return this.sheet;
    }

    public void setAlternativeExpression(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setAlternateExpression(bl);
    }

    public void setAlternativeFormula(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setAlternateFormula(bl);
    }

    public void setAutobreaks(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setAutobreaks(bl);
    }

    public void setDialog(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setDialog(bl);
    }

    public void setDisplayGuts(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setDisplayGuts(bl);
    }

    public void setFitToPage(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setFitToPage(bl);
    }

    public void setRowSumsBelow(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setRowSumsBelow(bl);
    }

    public void setRowSumsRight(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setRowSumsRight(bl);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    public boolean getAutobreaks() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    public boolean getFitToPage() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    public void setPrintGridlines(boolean bl) {
        this.getSheet().getPrintGridlines().setPrintGridlines(bl);
    }

    public HSSFPrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this.getSheet().getPrintSetup());
    }

    public HSSFHeader getHeader() {
        return new HSSFHeader(this.getSheet().getHeader());
    }

    public HSSFFooter getFooter() {
        return new HSSFFooter(this.getSheet().getFooter());
    }

    public boolean isSelected() {
        return this.getSheet().getWindowTwo().getSelected();
    }

    public void setSelected(boolean bl) {
        this.getSheet().getWindowTwo().setSelected(bl);
    }

    public boolean isActive() {
        return this.getSheet().getWindowTwo().isActive();
    }

    public void setActive(boolean bl) {
        this.getSheet().getWindowTwo().setActive(bl);
    }

    public double getMargin(short s) {
        return this.getSheet().getMargin(s);
    }

    public void setMargin(short s, double d) {
        this.getSheet().setMargin(s, d);
    }

    public boolean getProtect() {
        return this.getSheet().isProtected()[0];
    }

    public short getPassword() {
        return this.getSheet().getPassword().getPassword();
    }

    public boolean getObjectProtect() {
        return this.getSheet().isProtected()[1];
    }

    public boolean getScenarioProtect() {
        return this.getSheet().isProtected()[2];
    }

    public void setProtect(boolean bl) {
        this.getSheet().getProtect().setProtect(bl);
    }

    public void protectSheet(String string) {
        this.getSheet().protectSheet(string, true, true);
    }

    public void setZoom(int n, int n2) {
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Numerator must be greater than 1 and less than 65536");
        }
        if (n2 < 1 || n2 > 65535) {
            throw new IllegalArgumentException("Denominator must be greater than 1 and less than 65536");
        }
        SCLRecord sCLRecord = new SCLRecord();
        sCLRecord.setNumerator((short)n);
        sCLRecord.setDenominator((short)n2);
        this.getSheet().setSCLRecord(sCLRecord);
    }

    public short getTopRow() {
        return this.sheet.getTopRow();
    }

    public short getLeftCol() {
        return this.sheet.getLeftCol();
    }

    public void showInPane(short s, short s2) {
        this.sheet.setTopRow(s);
        this.sheet.setLeftCol(s2);
    }

    protected void shiftMerged(int n, int n2, int n3, boolean bl) {
        Region region;
        ArrayList<Region> arrayList = new ArrayList<Region>();
        for (int i = 0; i < this.getNumMergedRegions(); ++i) {
            boolean bl2;
            region = this.getMergedRegionAt(i);
            boolean bl3 = region.getRowFrom() >= n || region.getRowTo() >= n;
            boolean bl4 = bl2 = region.getRowTo() <= n2 || region.getRowFrom() <= n2;
            if (!bl3 || !bl2 || region.contains(n - 1, (short)0) || region.contains(n2 + 1, (short)0)) continue;
            region.setRowFrom(region.getRowFrom() + n3);
            region.setRowTo(region.getRowTo() + n3);
            arrayList.add(region);
            this.removeMergedRegion(i);
            --i;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            region = (Region)iterator.next();
            this.addMergedRegion(region);
        }
    }

    public void shiftRows(int n, int n2, int n3) {
        this.shiftRows(n, n2, n3, false, false);
    }

    public void shiftRows(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        int n5;
        int n6;
        if (n3 < 0) {
            n6 = n;
            n5 = n2;
            n4 = 1;
        } else {
            n6 = n2;
            n5 = n;
            n4 = -1;
        }
        this.shiftMerged(n, n2, n3, true);
        this.sheet.shiftRowBreaks(n, n2, n3);
        for (int i = n6; i >= n && i <= n2 && i >= 0 && i < 65536; i += n4) {
            HSSFCell hSSFCell;
            short s;
            HSSFRow hSSFRow = this.getRow(i);
            HSSFRow hSSFRow2 = this.getRow(i + n3);
            if (hSSFRow2 == null) {
                hSSFRow2 = this.createRow(i + n3);
            }
            for (s = hSSFRow2.getFirstCellNum(); s <= hSSFRow2.getLastCellNum(); s = (short)(s + 1)) {
                hSSFCell = hSSFRow2.getCell(s);
                if (hSSFCell == null) continue;
                hSSFRow2.removeCell(hSSFCell);
            }
            if (hSSFRow == null) continue;
            if (bl) {
                hSSFRow2.setHeight(hSSFRow.getHeight());
            }
            if (bl2) {
                hSSFRow.setHeight((short)255);
            }
            for (s = hSSFRow.getFirstCellNum(); s <= hSSFRow.getLastCellNum(); s = (short)(s + 1)) {
                Object object;
                hSSFCell = hSSFRow.getCell(s);
                if (hSSFCell != null) {
                    hSSFRow.removeCell(hSSFCell);
                    object = hSSFCell.getCellValueRecord();
                    object.setRow(i + n3);
                    hSSFRow2.createCellFromRecord((CellValueRecordInterface)object);
                    this.sheet.addValueRecord(i + n3, (CellValueRecordInterface)object);
                }
                if ((object = this.getCellComment(i, s)) == null) continue;
                ((HSSFComment)object).setRow(i + n3);
            }
        }
        if (n2 == this.lastrow || n2 + n3 > this.lastrow) {
            this.lastrow = Math.min(n2 + n3, 65535);
        }
        if (n == this.firstrow || n + n3 < this.firstrow) {
            this.firstrow = Math.max(n + n3, 0);
        }
        this.updateFormulasAfterShift(n, n2, n3);
    }

    private void updateFormulasAfterShift(int n, int n2, int n3) {
        Iterator iterator = this.rowIterator();
        while (iterator.hasNext()) {
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            Iterator iterator2 = hSSFRow.cellIterator();
            while (iterator2.hasNext()) {
                HSSFCell hSSFCell = (HSSFCell)iterator2.next();
                if (hSSFCell.getCellType() != 2) continue;
                FormulaParser formulaParser = new FormulaParser(hSSFCell.getCellFormula(), this.workbook);
                formulaParser.parse();
                Ptg[] ptgArray = formulaParser.getRPNPtg();
                boolean bl = false;
                for (int i = 0; i < ptgArray.length; ++i) {
                    RefPtg refPtg;
                    if (!(ptgArray[i] instanceof RefPtg) || n > (refPtg = (RefPtg)ptgArray[i]).getRowAsInt() || refPtg.getRowAsInt() > n2) continue;
                    refPtg.setRow(refPtg.getRowAsInt() + n3);
                    bl = true;
                }
                if (!bl) continue;
                hSSFCell.setCellFormula(formulaParser.toFormulaString(ptgArray));
            }
        }
    }

    protected void insertChartRecords(List list) {
        int n = this.sheet.findFirstRecordLocBySid((short)574);
        this.sheet.getRecords().addAll(n, list);
    }

    public void createFreezePane(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Column must be between 0 and 255");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("Row must be between 0 and 65535");
        }
        if (n3 < n) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (n4 < n2) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(n, n2, n4, n3);
    }

    public void createFreezePane(int n, int n2) {
        this.createFreezePane(n, n2, n, n2);
    }

    public void createSplitPane(int n, int n2, int n3, int n4, int n5) {
        this.getSheet().createSplitPane(n, n2, n4, n3, n5);
    }

    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    public void setDisplayGridlines(boolean bl) {
        this.sheet.setDisplayGridlines(bl);
    }

    public boolean isDisplayGridlines() {
        return this.sheet.isDisplayGridlines();
    }

    public void setDisplayFormulas(boolean bl) {
        this.sheet.setDisplayFormulas(bl);
    }

    public boolean isDisplayFormulas() {
        return this.sheet.isDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean bl) {
        this.sheet.setDisplayRowColHeadings(bl);
    }

    public boolean isDisplayRowColHeadings() {
        return this.sheet.isDisplayRowColHeadings();
    }

    public void setRowBreak(int n) {
        this.validateRow(n);
        this.sheet.setRowBreak(n, (short)0, (short)255);
    }

    public boolean isRowBroken(int n) {
        return this.sheet.isRowBroken(n);
    }

    public void removeRowBreak(int n) {
        this.sheet.removeRowBreak(n);
    }

    public int[] getRowBreaks() {
        int n = this.sheet.getNumRowBreaks();
        if (n > 0) {
            int[] nArray = new int[n];
            Iterator iterator = this.sheet.getRowBreaks();
            int n2 = 0;
            while (iterator.hasNext()) {
                PageBreakRecord.Break break_ = (PageBreakRecord.Break)iterator.next();
                nArray[n2++] = break_.main;
            }
            return nArray;
        }
        return null;
    }

    public short[] getColumnBreaks() {
        int n = this.sheet.getNumColumnBreaks();
        if (n > 0) {
            short[] sArray = new short[n];
            Iterator iterator = this.sheet.getColumnBreaks();
            int n2 = 0;
            while (iterator.hasNext()) {
                PageBreakRecord.Break break_ = (PageBreakRecord.Break)iterator.next();
                sArray[n2++] = break_.main;
            }
            return sArray;
        }
        return null;
    }

    public void setColumnBreak(short s) {
        this.validateColumn(s);
        this.sheet.setColumnBreak(s, (short)0, (short)-1);
    }

    public boolean isColumnBroken(short s) {
        return this.sheet.isColumnBroken(s);
    }

    public void removeColumnBreak(short s) {
        this.sheet.removeColumnBreak(s);
    }

    protected void validateRow(int n) {
        if (n > 65535) {
            throw new IllegalArgumentException("Maximum row number is 65535");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(short s) {
        if (s > 255) {
            throw new IllegalArgumentException("Maximum column number is 255");
        }
        if (s < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean bl) {
        this.sheet.aggregateDrawingRecords(this.book.getDrawingManager(), false);
        EscherAggregate escherAggregate = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List list = escherAggregate.getEscherRecords();
        PrintWriter printWriter = new PrintWriter(System.out);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (bl) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(printWriter, 0);
        }
        printWriter.flush();
    }

    public HSSFPatriarch createDrawingPatriarch() {
        this.book.createDrawingGroup();
        this.sheet.aggregateDrawingRecords(this.book.getDrawingManager(), true);
        EscherAggregate escherAggregate = (EscherAggregate)this.sheet.findFirstRecordBySid((short)9876);
        HSSFPatriarch hSSFPatriarch = new HSSFPatriarch(this, escherAggregate);
        escherAggregate.clear();
        escherAggregate.setPatriarch(hSSFPatriarch);
        return hSSFPatriarch;
    }

    public EscherAggregate getDrawingEscherAggregate() {
        this.book.findDrawingGroup();
        if (this.book.getDrawingManager() == null) {
            return null;
        }
        int n = this.sheet.aggregateDrawingRecords(this.book.getDrawingManager(), false);
        if (n == -1) {
            return null;
        }
        EscherAggregate escherAggregate = (EscherAggregate)this.sheet.findFirstRecordBySid((short)9876);
        return escherAggregate;
    }

    public HSSFPatriarch getDrawingPatriarch() {
        EscherAggregate escherAggregate = this.getDrawingEscherAggregate();
        if (escherAggregate == null) {
            return null;
        }
        HSSFPatriarch hSSFPatriarch = new HSSFPatriarch(this, escherAggregate);
        escherAggregate.setPatriarch(hSSFPatriarch);
        escherAggregate.convertRecordsToUserModel();
        return hSSFPatriarch;
    }

    public void setColumnGroupCollapsed(short s, boolean bl) {
        this.sheet.setColumnGroupCollapsed(s, bl);
    }

    public void groupColumn(short s, short s2) {
        this.sheet.groupColumnRange(s, s2, true);
    }

    public void ungroupColumn(short s, short s2) {
        this.sheet.groupColumnRange(s, s2, false);
    }

    public void groupRow(int n, int n2) {
        this.sheet.groupRowRange(n, n2, true);
    }

    public void ungroupRow(int n, int n2) {
        this.sheet.groupRowRange(n, n2, false);
    }

    public void setRowGroupCollapsed(int n, boolean bl) {
        this.sheet.setRowGroupCollapsed(n, bl);
    }

    public void setDefaultColumnStyle(short s, HSSFCellStyle hSSFCellStyle) {
        this.sheet.setColumn(s, new Short(hSSFCellStyle.getIndex()), null, null, null, null);
    }

    public void autoSizeColumn(short s) {
        this.autoSizeColumn(s, false);
    }

    public void autoSizeColumn(short s, boolean bl) {
        char c = '0';
        double d = 2.0;
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(this.book);
        HSSFFont hSSFFont = hSSFWorkbook.getFontAt((short)0);
        AttributedString attributedString = new AttributedString("" + c);
        this.copyAttributes(hSSFFont, attributedString, 0, 1);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        int n = (int)textLayout.getAdvance();
        double d2 = -1.0;
        Iterator iterator = this.rowIterator();
        block2: while (iterator.hasNext()) {
            Object object;
            Object object2;
            HSSFFont hSSFFont2;
            HSSFCellStyle hSSFCellStyle;
            int n2;
            HSSFCell hSSFCell;
            block16: {
                Object object3;
                String string;
                int n3;
                HSSFRow hSSFRow = (HSSFRow)iterator.next();
                hSSFCell = hSSFRow.getCell(s);
                if (hSSFCell == null) continue;
                n2 = 1;
                for (int i = 0; i < this.getNumMergedRegions(); ++i) {
                    if (!this.getMergedRegionAt(i).contains(hSSFRow.getRowNum(), s)) continue;
                    if (!bl) continue block2;
                    hSSFCell = hSSFRow.getCell(this.getMergedRegionAt(i).getColumnFrom());
                    n2 = 1 + this.getMergedRegionAt(i).getColumnTo() - this.getMergedRegionAt(i).getColumnFrom();
                }
                hSSFCellStyle = hSSFCell.getCellStyle();
                hSSFFont2 = hSSFWorkbook.getFontAt(hSSFCellStyle.getFontIndex());
                if (hSSFCell.getCellType() == 1) {
                    object2 = hSSFCell.getRichStringCellValue();
                    object = ((HSSFRichTextString)object2).getString().split("\\n");
                    for (n3 = 0; n3 < ((String[])object).length; ++n3) {
                        string = (String)object[n3] + c;
                        attributedString = new AttributedString(string);
                        this.copyAttributes(hSSFFont2, attributedString, 0, string.length());
                        if (((HSSFRichTextString)object2).numFormattingRuns() > 0) {
                            for (int i = 0; i < ((String)object[n3]).length(); ++i) {
                                short s2 = ((HSSFRichTextString)object2).getFontAtIndex(i);
                                if (s2 == 0) continue;
                                object3 = hSSFWorkbook.getFontAt(s2);
                                this.copyAttributes((HSSFFont)object3, attributedString, i, i + 1);
                            }
                        }
                        textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
                        if (hSSFCellStyle.getRotation() != 0) {
                            AffineTransform affineTransform = new AffineTransform();
                            affineTransform.concatenate(AffineTransform.getRotateInstance((double)hSSFCellStyle.getRotation() * 2.0 * Math.PI / 360.0));
                            affineTransform.concatenate(AffineTransform.getScaleInstance(1.0, d));
                            d2 = Math.max(d2, textLayout.getOutline(affineTransform).getBounds().getWidth() / (double)n2 / (double)n + (double)hSSFCell.getCellStyle().getIndention());
                            continue;
                        }
                        d2 = Math.max(d2, textLayout.getBounds().getWidth() / (double)n2 / (double)n + (double)hSSFCell.getCellStyle().getIndention());
                    }
                    continue;
                }
                object2 = null;
                if (hSSFCell.getCellType() == 0) {
                    object = hSSFWorkbook.createDataFormat();
                    n3 = hSSFCellStyle.getDataFormat();
                    string = ((HSSFDataFormat)object).getFormat((short)n3).replaceAll("\"", "");
                    double d3 = hSSFCell.getNumericCellValue();
                    try {
                        if ("General".equals(string)) {
                            object2 = "" + d3;
                            break block16;
                        }
                        object3 = new DecimalFormat(string);
                        object2 = ((NumberFormat)object3).format(d3);
                    }
                    catch (Exception exception) {
                        object2 = "" + d3;
                    }
                } else if (hSSFCell.getCellType() == 4) {
                    object2 = String.valueOf(hSSFCell.getBooleanCellValue());
                }
            }
            if (object2 == null) continue;
            object = (String)object2 + c;
            attributedString = new AttributedString((String)object);
            this.copyAttributes(hSSFFont2, attributedString, 0, ((String)object).length());
            textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            if (hSSFCellStyle.getRotation() != 0) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.concatenate(AffineTransform.getRotateInstance((double)hSSFCellStyle.getRotation() * 2.0 * Math.PI / 360.0));
                affineTransform.concatenate(AffineTransform.getScaleInstance(1.0, d));
                d2 = Math.max(d2, textLayout.getOutline(affineTransform).getBounds().getWidth() / (double)n2 / (double)n + (double)hSSFCell.getCellStyle().getIndention());
                continue;
            }
            d2 = Math.max(d2, textLayout.getBounds().getWidth() / (double)n2 / (double)n + (double)hSSFCell.getCellStyle().getIndention());
        }
        if (d2 != -1.0) {
            if (d2 > 32767.0) {
                d2 = 32767.0;
            }
            this.sheet.setColumnWidth(s, (short)(d2 * 256.0));
        }
    }

    private void copyAttributes(HSSFFont hSSFFont, AttributedString attributedString, int n, int n2) {
        attributedString.addAttribute(TextAttribute.FAMILY, hSSFFont.getFontName(), n, n2);
        attributedString.addAttribute(TextAttribute.SIZE, new Float(hSSFFont.getFontHeightInPoints()));
        if (hSSFFont.getBoldweight() == 700) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, n, n2);
        }
        if (hSSFFont.getItalic()) {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, n, n2);
        }
        if (hSSFFont.getUnderline() == 1) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, n, n2);
        }
    }

    public HSSFComment getCellComment(int n, int n2) {
        HSSFRow hSSFRow = this.getRow(n);
        if (hSSFRow != null) {
            HSSFCell hSSFCell = hSSFRow.getCell((short)n2);
            if (hSSFCell != null) {
                return hSSFCell.getCellComment();
            }
            return HSSFCell.findCellComment(this.sheet, n, n2);
        }
        return null;
    }

    public HSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new HSSFSheetConditionalFormatting(this.workbook, this.sheet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

