/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFClientAnchor;

public abstract class HSSFShape {
    public static final int LINEWIDTH_ONE_PT = 12700;
    public static final int LINEWIDTH_DEFAULT = 9525;
    public static final int LINESTYLE_SOLID = 0;
    public static final int LINESTYLE_DASHSYS = 1;
    public static final int LINESTYLE_DOTSYS = 2;
    public static final int LINESTYLE_DASHDOTSYS = 3;
    public static final int LINESTYLE_DASHDOTDOTSYS = 4;
    public static final int LINESTYLE_DOTGEL = 5;
    public static final int LINESTYLE_DASHGEL = 6;
    public static final int LINESTYLE_LONGDASHGEL = 7;
    public static final int LINESTYLE_DASHDOTGEL = 8;
    public static final int LINESTYLE_LONGDASHDOTGEL = 9;
    public static final int LINESTYLE_LONGDASHDOTDOTGEL = 10;
    public static final int LINESTYLE_NONE = -1;
    HSSFShape parent;
    HSSFAnchor anchor;
    int lineStyleColor = 0x8000040;
    int fillColor = 0x8000009;
    int lineWidth = 9525;
    int lineStyle = 0;
    boolean noFill = false;

    HSSFShape(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        this.parent = hSSFShape;
        this.anchor = hSSFAnchor;
    }

    public HSSFShape getParent() {
        return this.parent;
    }

    public HSSFAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(HSSFAnchor hSSFAnchor) {
        if (this.parent == null) {
            if (hSSFAnchor instanceof HSSFChildAnchor) {
                throw new IllegalArgumentException("Must use client anchors for shapes directly attached to sheet.");
            }
        } else if (hSSFAnchor instanceof HSSFClientAnchor) {
            throw new IllegalArgumentException("Must use child anchors for shapes attached to groups.");
        }
        this.anchor = hSSFAnchor;
    }

    public int getLineStyleColor() {
        return this.lineStyleColor;
    }

    public void setLineStyleColor(int n) {
        this.lineStyleColor = n;
    }

    public void setLineStyleColor(int n, int n2, int n3) {
        this.lineStyleColor = n3 << 16 | n2 << 8 | n;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int n) {
        this.fillColor = n;
    }

    public void setFillColor(int n, int n2, int n3) {
        this.fillColor = n3 << 16 | n2 << 8 | n;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public boolean isNoFill() {
        return this.noFill;
    }

    public void setNoFill(boolean bl) {
        this.noFill = bl;
    }

    public int countOfAllChildren() {
        return 1;
    }
}

