/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class HSSFRow
implements Comparable {
    public static final int INITIAL_CAPACITY = 5;
    private int rowNum;
    private HSSFCell[] cells = new HSSFCell[5];
    private RowRecord row;
    private HSSFWorkbook book;
    private Sheet sheet;
    public static final MissingCellPolicy RETURN_NULL_AND_BLANK = new MissingCellPolicy();
    public static final MissingCellPolicy RETURN_BLANK_AS_NULL = new MissingCellPolicy();
    public static final MissingCellPolicy CREATE_NULL_AS_BLANK = new MissingCellPolicy();

    HSSFRow() {
    }

    HSSFRow(HSSFWorkbook hSSFWorkbook, Sheet sheet, int n) {
        this.rowNum = n;
        this.book = hSSFWorkbook;
        this.sheet = sheet;
        this.row = new RowRecord(n);
        this.setRowNum(n);
    }

    HSSFRow(HSSFWorkbook hSSFWorkbook, Sheet sheet, RowRecord rowRecord) {
        this.book = hSSFWorkbook;
        this.sheet = sheet;
        this.row = rowRecord;
        this.setRowNum(rowRecord.getRowNumber());
    }

    public HSSFCell createCell(short s) {
        return this.createCell(s, 3);
    }

    public HSSFCell createCell(short s, int n) {
        HSSFCell hSSFCell = new HSSFCell(this.book, this.sheet, this.getRowNum(), s, n);
        this.addCell(hSSFCell);
        this.sheet.addValueRecord(this.getRowNum(), hSSFCell.getCellValueRecord());
        return hSSFCell;
    }

    public void removeCell(HSSFCell hSSFCell) {
        if (hSSFCell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        this.removeCell(hSSFCell, true);
    }

    private void removeCell(HSSFCell hSSFCell, boolean bl) {
        short s = hSSFCell.getCellNum();
        if (s < 0) {
            throw new RuntimeException("Negative cell indexes not allowed");
        }
        if (s >= this.cells.length || hSSFCell != this.cells[s]) {
            throw new RuntimeException("Specified cell is not from this row");
        }
        this.cells[s] = null;
        if (bl) {
            CellValueRecordInterface cellValueRecordInterface = hSSFCell.getCellValueRecord();
            this.sheet.removeValueRecord(this.getRowNum(), cellValueRecordInterface);
        }
        if (hSSFCell.getCellNum() + 1 == this.row.getLastCol()) {
            this.row.setLastCol((short)(this.findLastCell(this.row.getLastCol()) + 1));
        }
        if (hSSFCell.getCellNum() == this.row.getFirstCol()) {
            this.row.setFirstCol(this.findFirstCell(this.row.getFirstCol()));
        }
    }

    protected HSSFCell createCellFromRecord(CellValueRecordInterface cellValueRecordInterface) {
        HSSFCell hSSFCell = new HSSFCell(this.book, this.sheet, this.getRowNum(), cellValueRecordInterface);
        this.addCell(hSSFCell);
        return hSSFCell;
    }

    public void setRowNum(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid row number (" + n + ") outside allowable range (0.." + 65535 + ")");
        }
        this.rowNum = n;
        if (this.row != null) {
            this.row.setRowNumber(n);
        }
    }

    public int getRowNum() {
        return this.rowNum;
    }

    protected int getOutlineLevel() {
        return this.row.getOutlineLevel();
    }

    public void moveCell(HSSFCell hSSFCell, short s) {
        if (this.cells.length > s && this.cells[s] != null) {
            throw new IllegalArgumentException("Asked to move cell to column " + s + " but there's already a cell there");
        }
        if (!this.cells[hSSFCell.getCellNum()].equals(hSSFCell)) {
            throw new IllegalArgumentException("Asked to move a cell, but it didn't belong to our row");
        }
        this.removeCell(hSSFCell, false);
        hSSFCell.updateCellNum(s);
        this.addCell(hSSFCell);
    }

    private void addCell(HSSFCell hSSFCell) {
        short s = hSSFCell.getCellNum();
        if (s >= this.cells.length) {
            HSSFCell[] hSSFCellArray = this.cells;
            int n = hSSFCellArray.length * 2;
            if (n < s + 1) {
                n = s + 1;
            }
            this.cells = new HSSFCell[n];
            System.arraycopy(hSSFCellArray, 0, this.cells, 0, hSSFCellArray.length);
        }
        this.cells[s] = hSSFCell;
        if (this.row.getFirstCol() == -1 || s < this.row.getFirstCol()) {
            this.row.setFirstCol(s);
        }
        if (this.row.getLastCol() == -1 || s >= this.row.getLastCol()) {
            this.row.setLastCol((short)(s + 1));
        }
    }

    private HSSFCell retrieveCell(int n) {
        if (n < 0 || n >= this.cells.length) {
            return null;
        }
        return this.cells[n];
    }

    public HSSFCell getCell(short s) {
        int n = s & 0xFFFF;
        return this.getCell(n);
    }

    public HSSFCell getCell(int n) {
        return this.getCell(n, this.book.getMissingCellPolicy());
    }

    public HSSFCell getCell(int n, MissingCellPolicy missingCellPolicy) {
        HSSFCell hSSFCell = this.retrieveCell(n);
        if (missingCellPolicy == RETURN_NULL_AND_BLANK) {
            return hSSFCell;
        }
        if (missingCellPolicy == RETURN_BLANK_AS_NULL) {
            if (hSSFCell == null) {
                return hSSFCell;
            }
            if (hSSFCell.getCellType() == 3) {
                return null;
            }
            return hSSFCell;
        }
        if (missingCellPolicy == CREATE_NULL_AS_BLANK) {
            if (hSSFCell == null) {
                return this.createCell((short)n, 3);
            }
            return hSSFCell;
        }
        throw new IllegalArgumentException("Illegal policy " + missingCellPolicy + " (" + missingCellPolicy.id + ")");
    }

    public short getFirstCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getFirstCol();
    }

    public short getLastCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getLastCol();
    }

    public int getPhysicalNumberOfCells() {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        return n;
    }

    public void setHeight(short s) {
        this.row.setBadFontHeight(true);
        this.row.setHeight(s);
    }

    public void setZeroHeight(boolean bl) {
        this.row.setZeroHeight(bl);
    }

    public boolean getZeroHeight() {
        return this.row.getZeroHeight();
    }

    public void setHeightInPoints(float f) {
        this.row.setBadFontHeight(true);
        this.row.setHeight((short)(f * 20.0f));
    }

    public short getHeight() {
        return this.row.getHeight();
    }

    public float getHeightInPoints() {
        return this.row.getHeight() / 20;
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    private short findLastCell(short s) {
        short s2;
        HSSFCell hSSFCell = this.getCell(s2);
        for (s2 = (short)(s - 1); hSSFCell == null && s2 >= 0; s2 = (short)(s2 - 1)) {
            hSSFCell = this.getCell(s2);
        }
        return s2;
    }

    private short findFirstCell(short s) {
        short s2;
        HSSFCell hSSFCell = this.getCell(s2);
        for (s2 = (short)(s + 1); hSSFCell == null && s2 <= this.getLastCellNum(); s2 = (short)(s2 + 1)) {
            hSSFCell = this.getCell(s2);
        }
        if (s2 > this.getLastCellNum()) {
            return -1;
        }
        return s2;
    }

    public Iterator cellIterator() {
        return new CellIterator();
    }

    public Iterator iterator() {
        return this.cellIterator();
    }

    public int compareTo(Object object) {
        HSSFRow hSSFRow = (HSSFRow)object;
        if (this.getRowNum() == hSSFRow.getRowNum()) {
            return 0;
        }
        if (this.getRowNum() < hSSFRow.getRowNum()) {
            return -1;
        }
        if (this.getRowNum() > hSSFRow.getRowNum()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HSSFRow)) {
            return false;
        }
        HSSFRow hSSFRow = (HSSFRow)object;
        return this.getRowNum() == hSSFRow.getRowNum();
    }

    private class CellIterator
    implements Iterator {
        int thisId = -1;
        int nextId = -1;

        public CellIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextId < HSSFRow.this.cells.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            HSSFCell hSSFCell = HSSFRow.this.cells[this.nextId];
            this.thisId = this.nextId;
            this.findNext();
            return hSSFCell;
        }

        public void remove() {
            if (this.thisId == -1) {
                throw new IllegalStateException("remove() called before next()");
            }
            ((HSSFRow)HSSFRow.this).cells[this.thisId] = null;
        }

        private void findNext() {
            int n;
            for (n = this.nextId + 1; n < HSSFRow.this.cells.length && HSSFRow.this.cells[n] == null; ++n) {
            }
            this.nextId = n;
        }
    }

    public static class MissingCellPolicy {
        private static int NEXT_ID = 1;
        private final int id = NEXT_ID++;

        private MissingCellPolicy() {
        }
    }
}

