/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import java.util.Iterator;

public class HSSFRichTextString
implements Comparable {
    public static final short NO_FONT = 0;
    private UnicodeString string;
    private Workbook book;
    private LabelSSTRecord record;

    public HSSFRichTextString() {
        this("");
    }

    public HSSFRichTextString(String string) {
        if (string == null) {
            string = "";
        }
        this.string = new UnicodeString(string);
    }

    HSSFRichTextString(Workbook workbook, LabelSSTRecord labelSSTRecord) {
        this.setWorkbookReferences(workbook, labelSSTRecord);
        this.string = workbook.getSSTString(labelSSTRecord.getSSTIndex());
    }

    void setWorkbookReferences(Workbook workbook, LabelSSTRecord labelSSTRecord) {
        this.book = workbook;
        this.record = labelSSTRecord;
    }

    private UnicodeString cloneStringIfRequired() {
        if (this.book == null) {
            return this.string;
        }
        UnicodeString unicodeString = (UnicodeString)this.string.clone();
        return unicodeString;
    }

    private void addToSSTIfRequired() {
        if (this.book != null) {
            int n = this.book.addSSTString(this.string);
            this.record.setSSTIndex(n);
            this.string = this.book.getSSTString(n);
        }
    }

    public void applyFont(int n, int n2, short s) {
        if (n > n2) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
        if (n < 0 || n2 > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range.");
        }
        if (n == n2) {
            return;
        }
        short s2 = 0;
        if (n2 != this.length()) {
            s2 = this.getFontAtIndex(n);
        }
        this.string = this.cloneStringIfRequired();
        Iterator iterator = this.string.formatIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                UnicodeString.FormatRun formatRun = (UnicodeString.FormatRun)iterator.next();
                if (formatRun.getCharacterPos() < n || formatRun.getCharacterPos() >= n2) continue;
                iterator.remove();
            }
        }
        this.string.addFormatRun(new UnicodeString.FormatRun((short)n, s));
        if (n2 != this.length()) {
            this.string.addFormatRun(new UnicodeString.FormatRun((short)n2, s2));
        }
        this.addToSSTIfRequired();
    }

    public void applyFont(int n, int n2, HSSFFont hSSFFont) {
        this.applyFont(n, n2, hSSFFont.getIndex());
    }

    public void applyFont(HSSFFont hSSFFont) {
        this.applyFont(0, (int)this.string.getCharCount(), hSSFFont);
    }

    public void clearFormatting() {
        this.string = this.cloneStringIfRequired();
        this.string.clearFormatting();
        this.addToSSTIfRequired();
    }

    public String getString() {
        return this.string.getString();
    }

    UnicodeString getUnicodeString() {
        return this.cloneStringIfRequired();
    }

    void setUnicodeString(UnicodeString unicodeString) {
        this.string = unicodeString;
    }

    public int length() {
        return this.string.getCharCount();
    }

    public short getFontAtIndex(int n) {
        UnicodeString.FormatRun formatRun;
        int n2 = this.string.getFormatRunCount();
        UnicodeString.FormatRun formatRun2 = null;
        for (int i = 0; i < n2 && (formatRun = this.string.getFormatRun(i)).getCharacterPos() <= n; ++i) {
            formatRun2 = formatRun;
        }
        if (formatRun2 == null) {
            return 0;
        }
        return formatRun2.getFontIndex();
    }

    public int numFormattingRuns() {
        return this.string.getFormatRunCount();
    }

    public int getIndexOfFormattingRun(int n) {
        UnicodeString.FormatRun formatRun = this.string.getFormatRun(n);
        return formatRun.getCharacterPos();
    }

    public short getFontOfFormattingRun(int n) {
        UnicodeString.FormatRun formatRun = this.string.getFormatRun(n);
        return formatRun.getFontIndex();
    }

    public int compareTo(Object object) {
        HSSFRichTextString hSSFRichTextString = (HSSFRichTextString)object;
        return this.string.compareTo(hSSFRichTextString.string);
    }

    public boolean equals(Object object) {
        if (object instanceof HSSFRichTextString) {
            return this.string.equals(((HSSFRichTextString)object).string);
        }
        return false;
    }

    public String toString() {
        return this.string.toString();
    }

    public void applyFont(short s) {
        this.applyFont(0, (int)this.string.getCharCount(), s);
    }
}

