/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.ddf.EscherBSERecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HSSFPicture
extends HSSFSimpleShape {
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static final float PX_DEFAULT = 32.0f;
    private static final float PX_MODIFIED = 36.56f;
    private static final int PX_ROW = 15;
    int pictureIndex;
    HSSFPatriarch patriarch;
    private static final POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFPicture == null ? (class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFPicture = HSSFPicture.class$("com.fr.third.org.apache.poi.hssf.usermodel.HSSFPicture")) : class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFPicture);
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$usermodel$HSSFPicture;

    HSSFPicture(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        this.setShapeType(8);
    }

    public int getPictureIndex() {
        return this.pictureIndex;
    }

    public void setPictureIndex(int n) {
        this.pictureIndex = n;
    }

    public void resize() {
        HSSFClientAnchor hSSFClientAnchor = (HSSFClientAnchor)this.getAnchor();
        hSSFClientAnchor.setAnchorType(2);
        HSSFClientAnchor hSSFClientAnchor2 = this.getPreferredSize();
        int n = hSSFClientAnchor.getRow1() + (hSSFClientAnchor2.getRow2() - hSSFClientAnchor2.getRow1());
        int n2 = hSSFClientAnchor.getCol1() + (hSSFClientAnchor2.getCol2() - hSSFClientAnchor2.getCol1());
        hSSFClientAnchor.setCol2((short)n2);
        hSSFClientAnchor.setDx1(0);
        hSSFClientAnchor.setDx2(hSSFClientAnchor2.getDx2());
        hSSFClientAnchor.setRow2(n);
        hSSFClientAnchor.setDy1(0);
        hSSFClientAnchor.setDy2(hSSFClientAnchor2.getDy2());
    }

    public HSSFClientAnchor getPreferredSize() {
        float f;
        HSSFClientAnchor hSSFClientAnchor = (HSSFClientAnchor)this.getAnchor();
        Dimension dimension = this.getImageDimension();
        float f2 = 0.0f;
        f2 += this.getColumnWidthInPixels(hSSFClientAnchor.col1) * (float)(1 - hSSFClientAnchor.dx1 / 1024);
        short s = (short)(hSSFClientAnchor.col1 + 1);
        int n = 0;
        while (f2 < (float)dimension.width) {
            short s2 = s;
            s = (short)(s + 1);
            f2 += this.getColumnWidthInPixels(s2);
        }
        if (f2 > (float)dimension.width) {
            s = (short)(s - 1);
            f = this.getColumnWidthInPixels(s);
            float f3 = f2 - (float)dimension.width;
            n = (int)((f - f3) / f * 1024.0f);
        }
        hSSFClientAnchor.col2 = s;
        hSSFClientAnchor.dx2 = n;
        f = 0.0f;
        f += (float)(1 - hSSFClientAnchor.dy1 / 256) * this.getRowHeightInPixels(hSSFClientAnchor.row1);
        int n2 = hSSFClientAnchor.row1 + 1;
        int n3 = 0;
        while (f < (float)dimension.height) {
            f += this.getRowHeightInPixels(n2++);
        }
        if (f > (float)dimension.height) {
            float f4 = this.getRowHeightInPixels(--n2);
            float f5 = f - (float)dimension.height;
            n3 = (int)((f4 - f5) / f4 * 256.0f);
        }
        hSSFClientAnchor.row2 = n2;
        hSSFClientAnchor.dy2 = n3;
        return hSSFClientAnchor;
    }

    private float getColumnWidthInPixels(short s) {
        short s2 = this.patriarch.sheet.getColumnWidth(s);
        float f = this.getPixelWidth(s);
        return (float)s2 / f;
    }

    private float getRowHeightInPixels(int n) {
        HSSFRow hSSFRow = this.patriarch.sheet.getRow(n);
        float f = hSSFRow != null ? (float)hSSFRow.getHeight() : (float)this.patriarch.sheet.getDefaultRowHeight();
        return f / 15.0f;
    }

    private float getPixelWidth(short s) {
        int n = this.patriarch.sheet.getDefaultColumnWidth() * 256;
        short s2 = this.patriarch.sheet.getColumnWidth(s);
        return s2 == n ? 32.0f : 36.56f;
    }

    protected int[] getResolution(ImageReader imageReader) throws IOException {
        int n = 96;
        int n2 = 96;
        double d = 25.4;
        Element element = (Element)imageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0");
        NodeList nodeList = element.getElementsByTagName("HorizontalPixelSize");
        if (nodeList != null && nodeList.getLength() == 1) {
            n = (int)(d / (double)Float.parseFloat(((Element)nodeList.item(0)).getAttribute("value")));
        }
        if ((nodeList = element.getElementsByTagName("VerticalPixelSize")) != null && nodeList.getLength() == 1) {
            n2 = (int)(d / (double)Float.parseFloat(((Element)nodeList.item(0)).getAttribute("value")));
        }
        return new int[]{n, n2};
    }

    public Dimension getImageDimension() {
        EscherBSERecord escherBSERecord = this.patriarch.sheet.book.getBSERecord(this.pictureIndex);
        byte[] byArray = escherBSERecord.getBlipRecord().getPicturedata();
        byte by = escherBSERecord.getBlipTypeWin32();
        Dimension dimension = new Dimension();
        switch (by) {
            case 5: 
            case 6: 
            case 7: {
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                    ImageReader imageReader = iterator.next();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    int[] nArray = this.getResolution(imageReader);
                    dimension.width = bufferedImage.getWidth() * 96 / nArray[0];
                    dimension.height = bufferedImage.getHeight() * 96 / nArray[1];
                    break;
                }
                catch (IOException iOException) {
                    log.log(5, iOException);
                }
            }
        }
        return dimension;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

