/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.ddf.EscherComplexProperty;
import com.fr.third.org.apache.poi.ddf.EscherOptRecord;
import com.fr.third.org.apache.poi.ddf.EscherProperty;
import com.fr.third.org.apache.poi.hssf.record.EscherAggregate;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPicture;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPolygon;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;
import com.fr.third.org.apache.poi.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HSSFPatriarch
implements HSSFShapeContainer {
    List shapes = new ArrayList();
    HSSFSheet sheet;
    int x1 = 0;
    int y1 = 0;
    int x2 = 1023;
    int y2 = 255;
    private EscherAggregate boundAggregate;

    HSSFPatriarch(HSSFSheet hSSFSheet, EscherAggregate escherAggregate) {
        this.boundAggregate = escherAggregate;
        this.sheet = hSSFSheet;
    }

    public HSSFShapeGroup createGroup(HSSFClientAnchor hSSFClientAnchor) {
        HSSFShapeGroup hSSFShapeGroup = new HSSFShapeGroup(null, hSSFClientAnchor);
        hSSFShapeGroup.anchor = hSSFClientAnchor;
        this.shapes.add(hSSFShapeGroup);
        return hSSFShapeGroup;
    }

    public HSSFSimpleShape createSimpleShape(HSSFClientAnchor hSSFClientAnchor) {
        HSSFSimpleShape hSSFSimpleShape = new HSSFSimpleShape(null, hSSFClientAnchor);
        hSSFSimpleShape.anchor = hSSFClientAnchor;
        this.shapes.add(hSSFSimpleShape);
        return hSSFSimpleShape;
    }

    public HSSFPicture createPicture(HSSFClientAnchor hSSFClientAnchor, int n) {
        HSSFPicture hSSFPicture = new HSSFPicture(null, hSSFClientAnchor);
        hSSFPicture.setPictureIndex(n);
        hSSFPicture.anchor = hSSFClientAnchor;
        hSSFPicture.patriarch = this;
        this.shapes.add(hSSFPicture);
        return hSSFPicture;
    }

    public HSSFPolygon createPolygon(HSSFClientAnchor hSSFClientAnchor) {
        HSSFPolygon hSSFPolygon = new HSSFPolygon(null, hSSFClientAnchor);
        hSSFPolygon.anchor = hSSFClientAnchor;
        this.shapes.add(hSSFPolygon);
        return hSSFPolygon;
    }

    public HSSFTextbox createTextbox(HSSFClientAnchor hSSFClientAnchor) {
        HSSFTextbox hSSFTextbox = new HSSFTextbox(null, hSSFClientAnchor);
        hSSFTextbox.anchor = hSSFClientAnchor;
        this.shapes.add(hSSFTextbox);
        return hSSFTextbox;
    }

    public HSSFComment createComment(HSSFAnchor hSSFAnchor) {
        HSSFComment hSSFComment = new HSSFComment(null, hSSFAnchor);
        hSSFComment.anchor = hSSFAnchor;
        this.shapes.add(hSSFComment);
        return hSSFComment;
    }

    public List getChildren() {
        return this.shapes;
    }

    public int countOfAllChildren() {
        int n = this.shapes.size();
        Iterator iterator = this.shapes.iterator();
        while (iterator.hasNext()) {
            HSSFShape hSSFShape = (HSSFShape)iterator.next();
            n += hSSFShape.countOfAllChildren();
        }
        return n;
    }

    public void setCoordinates(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
    }

    public boolean containsChart() {
        EscherOptRecord escherOptRecord = (EscherOptRecord)this.boundAggregate.findFirstWithId((short)-4085);
        if (escherOptRecord == null) {
            return false;
        }
        Iterator iterator = escherOptRecord.getEscherProperties().iterator();
        while (iterator.hasNext()) {
            EscherComplexProperty escherComplexProperty;
            String string;
            EscherProperty escherProperty = (EscherProperty)iterator.next();
            if (escherProperty.getPropertyNumber() != 896 || !escherProperty.isComplex() || !(string = StringUtil.getFromUnicodeLE((escherComplexProperty = (EscherComplexProperty)escherProperty).getComplexData())).equals("Chart 1\u0000")) continue;
            return true;
        }
        return false;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    protected EscherAggregate _getBoundAggregate() {
        return this.boundAggregate;
    }
}

