/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.PaletteRecord;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;

public class HSSFPalette {
    private PaletteRecord palette;

    protected HSSFPalette(PaletteRecord paletteRecord) {
        this.palette = paletteRecord;
    }

    public HSSFColor getColor(short s) {
        if (s == 64) {
            return HSSFColor.AUTOMATIC.getInstance();
        }
        byte[] byArray = this.palette.getColor(s);
        if (byArray != null) {
            return new CustomColor(s, byArray);
        }
        return null;
    }

    public HSSFColor findColor(byte by, byte by2, byte by3) {
        byte[] byArray = this.palette.getColor((short)8);
        short s = 8;
        while (byArray != null) {
            if (byArray[0] == by && byArray[1] == by2 && byArray[2] == by3) {
                return new CustomColor(s, byArray);
            }
            s = (short)(s + 1);
            byArray = this.palette.getColor(s);
        }
        return null;
    }

    public HSSFColor findSimilarColor(byte by, byte by2, byte by3) {
        HSSFColor hSSFColor = null;
        int n = Integer.MAX_VALUE;
        byte[] byArray = this.palette.getColor((short)8);
        short s = 8;
        while (byArray != null) {
            int n2 = Math.abs(by - byArray[0]) + Math.abs(by2 - byArray[1]) + Math.abs(by3 - byArray[2]);
            if (n2 < n) {
                n = n2;
                hSSFColor = this.getColor(s);
            }
            s = (short)(s + 1);
            byArray = this.palette.getColor(s);
        }
        return hSSFColor;
    }

    public void setColorAtIndex(short s, byte by, byte by2, byte by3) {
        this.palette.setColor(s, by, by2, by3);
    }

    public HSSFColor addColor(byte by, byte by2, byte by3) {
        byte[] byArray = this.palette.getColor((short)8);
        for (short s = 8; s < 64; s = (short)(s + 1)) {
            if (byArray == null) {
                this.setColorAtIndex(s, by, by2, by3);
                return this.getColor(s);
            }
            byArray = this.palette.getColor(s);
        }
        throw new RuntimeException("Could not find free color index");
    }

    private static class CustomColor
    extends HSSFColor {
        private short byteOffset;
        private byte red;
        private byte green;
        private byte blue;

        private CustomColor(short s, byte[] byArray) {
            this(s, byArray[0], byArray[1], byArray[2]);
        }

        private CustomColor(short s, byte by, byte by2, byte by3) {
            this.byteOffset = s;
            this.red = by;
            this.green = by2;
            this.blue = by3;
        }

        public short getIndex() {
            return this.byteOffset;
        }

        public short[] getTriplet() {
            return new short[]{(short)(this.red & 0xFF), (short)(this.green & 0xFF), (short)(this.blue & 0xFF)};
        }

        public String getHexString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getGnumericPart(this.red));
            stringBuffer.append(':');
            stringBuffer.append(this.getGnumericPart(this.green));
            stringBuffer.append(':');
            stringBuffer.append(this.getGnumericPart(this.blue));
            return stringBuffer.toString();
        }

        private String getGnumericPart(byte by) {
            String string;
            if (by == 0) {
                string = "0";
            } else {
                int n = by & 0xFF;
                n = n << 8 | n;
                string = Integer.toHexString(n).toUpperCase();
                while (string.length() < 4) {
                    string = "0" + string;
                }
            }
            return string;
        }
    }
}

