/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.Entry;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.org.apache.poi.util.HexDump;
import java.io.IOException;
import java.util.Iterator;

public class HSSFObjectData {
    private ObjRecord record;
    private POIFSFileSystem poifs;

    public HSSFObjectData(ObjRecord objRecord, POIFSFileSystem pOIFSFileSystem) {
        this.record = objRecord;
        this.poifs = pOIFSFileSystem;
    }

    public String getOLE2ClassName() {
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = this.findObjectRecord();
        return embeddedObjectRefSubRecord.field_5_ole_classname;
    }

    public DirectoryEntry getDirectory() throws IOException {
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = this.findObjectRecord();
        int n = embeddedObjectRefSubRecord.getStreamId();
        String string = "MBD" + HexDump.toHex(n);
        Entry entry = this.poifs.getRoot().getEntry(string);
        if (entry instanceof DirectoryEntry) {
            return (DirectoryEntry)entry;
        }
        throw new IOException("Stream " + string + " was not an OLE2 directory");
    }

    public byte[] getObjectData() {
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = this.findObjectRecord();
        return embeddedObjectRefSubRecord.remainingBytes;
    }

    public boolean hasDirectoryEntry() {
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = this.findObjectRecord();
        return embeddedObjectRefSubRecord.field_6_stream_id != 0;
    }

    protected EmbeddedObjectRefSubRecord findObjectRecord() {
        Iterator iterator = this.record.getSubRecords().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EmbeddedObjectRefSubRecord)) continue;
            return (EmbeddedObjectRefSubRecord)e;
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }
}

