/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.NameRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.RangeAddress;

public class HSSFName {
    private HSSFWorkbook book;
    private NameRecord name;

    protected HSSFName(HSSFWorkbook hSSFWorkbook, NameRecord nameRecord) {
        this.book = hSSFWorkbook;
        this.name = nameRecord;
    }

    public String getSheetName() {
        short s = this.name.getExternSheetNumber();
        String string = this.book.getWorkbook().findSheetNameFromExternSheet(s);
        return string;
    }

    public String getNameName() {
        String string = this.name.getNameText();
        return string;
    }

    public void setNameName(String string) {
        this.name.setNameText(string);
        this.name.setNameTextLength((byte)string.length());
        Workbook workbook = this.book.getWorkbook();
        for (int i = workbook.getNumNames() - 1; i >= 0; --i) {
            NameRecord nameRecord = workbook.getNameRecord(i);
            if (nameRecord == this.name || !nameRecord.getNameText().equalsIgnoreCase(this.getNameName())) continue;
            throw new IllegalArgumentException("The workbook already contains this name (case-insensitive)");
        }
    }

    public String getReference() {
        String string = this.name.getAreaReference(this.book);
        return string;
    }

    private void setSheetName(String string) {
        int n = this.book.getSheetIndex(string);
        short s = this.book.getExternalSheetIndex(n);
        this.name.setExternSheetNumber(s);
    }

    public void setReference(String string) {
        RangeAddress rangeAddress = new RangeAddress(string);
        String string2 = rangeAddress.getSheetName();
        if (rangeAddress.hasSheetName()) {
            this.setSheetName(string2);
        }
        this.name.setAreaReference(string);
    }

    public boolean isDeleted() {
        String string = this.getReference();
        return "#REF!".endsWith(string);
    }
}

