/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.BoolPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ControlPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.IntPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemErrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MissingArgPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NamePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NameXPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NumberPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.OperationPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtgBase;
import com.fr.third.org.apache.poi.hssf.record.formula.StringPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnknownPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Area2DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Area3DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.FunctionEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NameEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperationEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Ref2DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Ref3DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.usermodel.EvaluationCycleDetector;
import com.fr.third.org.apache.poi.hssf.usermodel.EvaluationCycleDetectorManager;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.usermodel.OperationEvaluatorFactory;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class HSSFFormulaEvaluator {
    private static final Class[] VALUE_CONTRUCTOR_CLASS_ARRAY = new Class[]{class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ptg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg};
    private static final Class[] AREA3D_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ptg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg, array$Lcom$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (array$Lcom$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("[Lcom.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;")) : array$Lcom$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Class[] REFERENCE_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ptg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg, class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Class[] REF3D_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ptg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg, class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Map VALUE_EVALS_MAP = new HashMap();
    protected HSSFRow row;
    protected HSSFSheet sheet;
    protected HSSFWorkbook workbook;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$Ptg;
    static /* synthetic */ Class array$Lcom$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$eval$ValueEval;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$BoolPtg;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$eval$BoolEval;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$IntPtg;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$NumberPtg;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$StringPtg;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval;

    public HSSFFormulaEvaluator(HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        this.sheet = hSSFSheet;
        this.workbook = hSSFWorkbook;
    }

    public void setCurrentRow(HSSFRow hSSFRow) {
        this.row = hSSFRow;
    }

    public static FormulaParser getUnderlyingParser(HSSFWorkbook hSSFWorkbook, String string) {
        return new FormulaParser(string, hSSFWorkbook);
    }

    public CellValue evaluate(HSSFCell hSSFCell) {
        CellValue cellValue = null;
        if (hSSFCell != null) {
            switch (hSSFCell.getCellType()) {
                case 3: {
                    cellValue = new CellValue(3);
                    break;
                }
                case 4: {
                    cellValue = new CellValue(4);
                    cellValue.setBooleanValue(hSSFCell.getBooleanCellValue());
                    break;
                }
                case 5: {
                    cellValue = new CellValue(5);
                    cellValue.setErrorValue(hSSFCell.getErrorCellValue());
                    break;
                }
                case 2: {
                    cellValue = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(hSSFCell, this.row, this.sheet, this.workbook));
                    break;
                }
                case 0: {
                    cellValue = new CellValue(0);
                    cellValue.setNumberValue(hSSFCell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellValue = new CellValue(1);
                    cellValue.setRichTextStringValue(hSSFCell.getRichStringCellValue());
                }
            }
        }
        return cellValue;
    }

    public int evaluateFormulaCell(HSSFCell hSSFCell) {
        if (hSSFCell != null) {
            switch (hSSFCell.getCellType()) {
                case 2: {
                    CellValue cellValue = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(hSSFCell, this.row, this.sheet, this.workbook));
                    switch (cellValue.getCellType()) {
                        case 4: {
                            hSSFCell.setCellValue(cellValue.getBooleanValue());
                            break;
                        }
                        case 5: {
                            hSSFCell.setCellValue(cellValue.getErrorValue());
                            break;
                        }
                        case 0: {
                            hSSFCell.setCellValue(cellValue.getNumberValue());
                            break;
                        }
                        case 1: {
                            hSSFCell.setCellValue(cellValue.getRichTextStringValue());
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    return cellValue.getCellType();
                }
            }
        }
        return -1;
    }

    public HSSFCell evaluateInCell(HSSFCell hSSFCell) {
        if (hSSFCell != null) {
            block0 : switch (hSSFCell.getCellType()) {
                case 2: {
                    CellValue cellValue = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(hSSFCell, this.row, this.sheet, this.workbook));
                    switch (cellValue.getCellType()) {
                        case 4: {
                            hSSFCell.setCellType(4);
                            hSSFCell.setCellValue(cellValue.getBooleanValue());
                            break block0;
                        }
                        case 5: {
                            hSSFCell.setCellErrorValue(cellValue.getErrorValue());
                            break block0;
                        }
                        case 0: {
                            hSSFCell.setCellType(0);
                            hSSFCell.setCellValue(cellValue.getNumberValue());
                            break block0;
                        }
                        case 1: {
                            hSSFCell.setCellType(1);
                            hSSFCell.setCellValue(cellValue.getRichTextStringValue());
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                }
            }
        }
        return hSSFCell;
    }

    public static void evaluateAllFormulaCells(HSSFWorkbook hSSFWorkbook) {
        for (int i = 0; i < hSSFWorkbook.getNumberOfSheets(); ++i) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i);
            HSSFFormulaEvaluator hSSFFormulaEvaluator = new HSSFFormulaEvaluator(hSSFSheet, hSSFWorkbook);
            Iterator iterator = hSSFSheet.rowIterator();
            while (iterator.hasNext()) {
                HSSFRow hSSFRow = (HSSFRow)iterator.next();
                hSSFFormulaEvaluator.setCurrentRow(hSSFRow);
                Iterator iterator2 = hSSFRow.cellIterator();
                while (iterator2.hasNext()) {
                    HSSFCell hSSFCell = (HSSFCell)iterator2.next();
                    if (hSSFCell.getCellType() != 2) continue;
                    hSSFFormulaEvaluator.evaluateFormulaCell(hSSFCell);
                }
            }
        }
    }

    protected static CellValue getCellValueForEval(ValueEval valueEval) {
        CellValue cellValue = null;
        if (valueEval != null) {
            if (valueEval instanceof NumberEval) {
                NumberEval numberEval = (NumberEval)valueEval;
                cellValue = new CellValue(0);
                cellValue.setNumberValue(numberEval.getNumberValue());
            } else if (valueEval instanceof BoolEval) {
                BoolEval boolEval = (BoolEval)valueEval;
                cellValue = new CellValue(4);
                cellValue.setBooleanValue(boolEval.getBooleanValue());
            } else if (valueEval instanceof StringEval) {
                StringEval stringEval = (StringEval)valueEval;
                cellValue = new CellValue(1);
                cellValue.setStringValue(stringEval.getStringValue());
            } else if (valueEval instanceof BlankEval) {
                cellValue = new CellValue(3);
            } else if (valueEval instanceof ErrorEval) {
                cellValue = new CellValue(5);
                cellValue.setErrorValue((byte)((ErrorEval)valueEval).getErrorCode());
            } else {
                cellValue = new CellValue(5);
            }
        }
        return cellValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValueEval internalEvaluate(HSSFCell hSSFCell, HSSFRow hSSFRow, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        int n = hSSFRow.getRowNum();
        short s = hSSFCell.getCellNum();
        EvaluationCycleDetector evaluationCycleDetector = EvaluationCycleDetectorManager.getTracker();
        if (!evaluationCycleDetector.startEvaluate(hSSFWorkbook, hSSFSheet, n, s)) {
            return ErrorEval.CIRCULAR_REF_ERROR;
        }
        try {
            ValueEval valueEval = HSSFFormulaEvaluator.evaluateCell(hSSFWorkbook, hSSFSheet, n, s, hSSFCell.getCellFormula());
            return valueEval;
        }
        finally {
            evaluationCycleDetector.endEvaluate(hSSFWorkbook, hSSFSheet, n, s);
        }
    }

    private static ValueEval evaluateCell(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, short s, String string) {
        Ptg[] ptgArray = FormulaParser.parse(string, hSSFWorkbook);
        Stack<Object> stack = new Stack<Object>();
        int n2 = ptgArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            Object object3;
            int n3;
            Eval eval;
            Object object4;
            Ptg ptg = ptgArray[i];
            if (ptg instanceof ControlPtg || ptg instanceof MemErrPtg || ptg instanceof MissingArgPtg) continue;
            if (ptg instanceof NamePtg) {
                object4 = (NamePtg)ptg;
                stack.push(new NameEval(((NamePtg)object4).getIndex()));
                continue;
            }
            if (ptg instanceof NameXPtg || ptg instanceof UnknownPtg) continue;
            if (ptg instanceof OperationPtg) {
                object4 = (OperationPtg)ptg;
                if (object4 instanceof UnionPtg) continue;
                eval = OperationEvaluatorFactory.create((OperationPtg)object4);
                n3 = eval.getNumberOfOperands();
                object3 = new Eval[n3];
                for (int j = n3 - 1; j >= 0; --j) {
                    object3[j] = object2 = (Eval)stack.pop();
                }
                object = HSSFFormulaEvaluator.invokeOperation(eval, (Eval[])object3, n, s, hSSFWorkbook, hSSFSheet);
                stack.push(object);
                continue;
            }
            if (ptg instanceof RefPtg) {
                object4 = (RefPtg)ptg;
                int n4 = ((RefPtgBase)object4).getColumn();
                n3 = ((RefPtgBase)object4).getRow();
                object3 = hSSFSheet.getRow(n3);
                object = object3 != null ? ((HSSFRow)object3).getCell(n4) : null;
                stack.push(HSSFFormulaEvaluator.createRef2DEval((RefPtg)object4, (HSSFCell)object, (HSSFRow)object3, hSSFSheet, hSSFWorkbook));
                continue;
            }
            if (ptg instanceof Ref3DPtg) {
                object4 = (Ref3DPtg)ptg;
                int n5 = ((Ref3DPtg)object4).getColumn();
                n3 = ((Ref3DPtg)object4).getRow();
                object3 = hSSFWorkbook.getWorkbook();
                object = hSSFWorkbook.getSheetAt(((Workbook)object3).getSheetIndexFromExternSheetIndex(((Ref3DPtg)object4).getExternSheetIndex()));
                object2 = ((HSSFSheet)object).getRow(n3);
                HSSFCell hSSFCell = object2 != null ? ((HSSFRow)object2).getCell(n5) : null;
                stack.push(HSSFFormulaEvaluator.createRef3DEval((Ref3DPtg)object4, hSSFCell, (HSSFRow)object2, (HSSFSheet)object, hSSFWorkbook));
                continue;
            }
            if (ptg instanceof AreaPtg) {
                object4 = (AreaPtg)ptg;
                eval = HSSFFormulaEvaluator.evaluateAreaPtg(hSSFSheet, hSSFWorkbook, (AreaPtg)object4);
                stack.push(eval);
                continue;
            }
            if (ptg instanceof Area3DPtg) {
                object4 = (Area3DPtg)ptg;
                eval = HSSFFormulaEvaluator.evaluateArea3dPtg(hSSFWorkbook, (Area3DPtg)object4);
                stack.push(eval);
                continue;
            }
            object4 = HSSFFormulaEvaluator.getEvalForPtg(ptg);
            stack.push(object4);
        }
        ValueEval valueEval = (ValueEval)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("evaluation stack not empty");
        }
        if ((valueEval = HSSFFormulaEvaluator.dereferenceValue(valueEval, n, s)) instanceof BlankEval) {
            return NumberEval.ZERO;
        }
        return valueEval;
    }

    private static ValueEval dereferenceValue(ValueEval valueEval, int n, short s) {
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            return refEval.getInnerValueEval();
        }
        if (valueEval instanceof AreaEval) {
            AreaEval areaEval = (AreaEval)valueEval;
            if (areaEval.isRow()) {
                if (areaEval.isColumn()) {
                    return areaEval.getValues()[0];
                }
                return areaEval.getValueAt(areaEval.getFirstRow(), s);
            }
            if (areaEval.isColumn()) {
                return areaEval.getValueAt(n, areaEval.getFirstColumn());
            }
            return ErrorEval.VALUE_INVALID;
        }
        return valueEval;
    }

    private static Eval invokeOperation(OperationEval operationEval, Eval[] evalArray, int n, short s, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet) {
        FunctionEval functionEval;
        if (operationEval instanceof FunctionEval && (functionEval = (FunctionEval)operationEval).isFreeRefFunction()) {
            return functionEval.getFreeRefFunction().evaluate(evalArray, n, s, hSSFWorkbook, hSSFSheet);
        }
        return operationEval.evaluate(evalArray, n, s);
    }

    public static AreaEval evaluateAreaPtg(HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, AreaPtg areaPtg) {
        int n = areaPtg.getFirstRow();
        int n2 = areaPtg.getFirstColumn();
        int n3 = areaPtg.getLastRow();
        int n4 = areaPtg.getLastColumn();
        if (n3 == -1 && n >= 0) {
            n3 = (short)hSSFSheet.getLastRowNum();
        }
        ValueEval[] valueEvalArray = HSSFFormulaEvaluator.evalArea(hSSFWorkbook, hSSFSheet, n, n2, n3, n4);
        return new Area2DEval(areaPtg, valueEvalArray);
    }

    public static AreaEval evaluateArea3dPtg(HSSFWorkbook hSSFWorkbook, Area3DPtg area3DPtg) {
        int n = area3DPtg.getFirstRow();
        int n2 = area3DPtg.getFirstColumn();
        int n3 = area3DPtg.getLastRow();
        int n4 = area3DPtg.getLastColumn();
        Workbook workbook = hSSFWorkbook.getWorkbook();
        HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(workbook.getSheetIndexFromExternSheetIndex(area3DPtg.getExternSheetIndex()));
        if (n3 == -1 && n >= 0) {
            n3 = (short)hSSFSheet.getLastRowNum();
        }
        ValueEval[] valueEvalArray = HSSFFormulaEvaluator.evalArea(hSSFWorkbook, hSSFSheet, n, n2, n3, n4);
        return new Area3DEval(area3DPtg, valueEvalArray);
    }

    private static ValueEval[] evalArea(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2, int n3, int n4) {
        ValueEval[] valueEvalArray = new ValueEval[(n3 - n + 1) * (n4 - n2 + 1)];
        for (int i = n; hSSFSheet != null && i < n3 + 1; ++i) {
            HSSFRow hSSFRow = hSSFSheet.getRow(i);
            for (int j = n2; j < n4 + 1; ++j) {
                ValueEval valueEval = hSSFRow == null ? BlankEval.INSTANCE : HSSFFormulaEvaluator.getEvalForCell(hSSFRow.getCell(j), hSSFRow, hSSFSheet, hSSFWorkbook);
                valueEvalArray[(i - n) * (n4 - n2 + 1) + (j - n2)] = valueEval;
            }
        }
        return valueEvalArray;
    }

    protected static Eval getEvalForPtg(Ptg ptg) {
        Eval eval = null;
        Class clazz = (Class)VALUE_EVALS_MAP.get(ptg.getClass());
        try {
            if (ptg instanceof Area3DPtg) {
                Constructor constructor = clazz.getConstructor(AREA3D_CONSTRUCTOR_CLASS_ARRAY);
                eval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof AreaPtg) {
                Constructor constructor = clazz.getConstructor(AREA3D_CONSTRUCTOR_CLASS_ARRAY);
                eval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof RefPtg) {
                Constructor constructor = clazz.getConstructor(REFERENCE_CONSTRUCTOR_CLASS_ARRAY);
                eval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof Ref3DPtg) {
                Constructor constructor = clazz.getConstructor(REF3D_CONSTRUCTOR_CLASS_ARRAY);
                eval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof IntPtg || ptg instanceof NumberPtg || ptg instanceof StringPtg || ptg instanceof BoolPtg) {
                Constructor constructor = clazz.getConstructor(VALUE_CONTRUCTOR_CLASS_ARRAY);
                eval = (ValueEval)constructor.newInstance(ptg);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Fatal Error: ", exception);
        }
        return eval;
    }

    protected static ValueEval getEvalForCell(HSSFCell hSSFCell, HSSFRow hSSFRow, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        if (hSSFCell == null) {
            return BlankEval.INSTANCE;
        }
        switch (hSSFCell.getCellType()) {
            case 0: {
                return new NumberEval(hSSFCell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(hSSFCell.getRichStringCellValue().getString());
            }
            case 2: {
                return HSSFFormulaEvaluator.internalEvaluate(hSSFCell, hSSFRow, hSSFSheet, hSSFWorkbook);
            }
            case 4: {
                return BoolEval.valueOf(hSSFCell.getBooleanCellValue());
            }
            case 3: {
                return BlankEval.INSTANCE;
            }
            case 5: {
                return ErrorEval.valueOf(hSSFCell.getErrorCellValue());
            }
        }
        throw new RuntimeException("Unexpected cell type (" + hSSFCell.getCellType() + ")");
    }

    private static Ref2DEval createRef2DEval(RefPtg refPtg, HSSFCell hSSFCell, HSSFRow hSSFRow, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        if (hSSFCell == null) {
            return new Ref2DEval(refPtg, BlankEval.INSTANCE);
        }
        switch (hSSFCell.getCellType()) {
            case 0: {
                return new Ref2DEval(refPtg, new NumberEval(hSSFCell.getNumericCellValue()));
            }
            case 1: {
                return new Ref2DEval(refPtg, new StringEval(hSSFCell.getRichStringCellValue().getString()));
            }
            case 2: {
                return new Ref2DEval(refPtg, HSSFFormulaEvaluator.internalEvaluate(hSSFCell, hSSFRow, hSSFSheet, hSSFWorkbook));
            }
            case 4: {
                return new Ref2DEval(refPtg, BoolEval.valueOf(hSSFCell.getBooleanCellValue()));
            }
            case 3: {
                return new Ref2DEval(refPtg, BlankEval.INSTANCE);
            }
            case 5: {
                return new Ref2DEval(refPtg, ErrorEval.valueOf(hSSFCell.getErrorCellValue()));
            }
        }
        throw new RuntimeException("Unexpected cell type (" + hSSFCell.getCellType() + ")");
    }

    private static Ref3DEval createRef3DEval(Ref3DPtg ref3DPtg, HSSFCell hSSFCell, HSSFRow hSSFRow, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        if (hSSFCell == null) {
            return new Ref3DEval(ref3DPtg, BlankEval.INSTANCE);
        }
        switch (hSSFCell.getCellType()) {
            case 0: {
                return new Ref3DEval(ref3DPtg, new NumberEval(hSSFCell.getNumericCellValue()));
            }
            case 1: {
                return new Ref3DEval(ref3DPtg, new StringEval(hSSFCell.getRichStringCellValue().getString()));
            }
            case 2: {
                return new Ref3DEval(ref3DPtg, HSSFFormulaEvaluator.internalEvaluate(hSSFCell, hSSFRow, hSSFSheet, hSSFWorkbook));
            }
            case 4: {
                return new Ref3DEval(ref3DPtg, BoolEval.valueOf(hSSFCell.getBooleanCellValue()));
            }
            case 3: {
                return new Ref3DEval(ref3DPtg, BlankEval.INSTANCE);
            }
            case 5: {
                return new Ref3DEval(ref3DPtg, ErrorEval.valueOf(hSSFCell.getErrorCellValue()));
            }
        }
        throw new RuntimeException("Unexpected cell type (" + hSSFCell.getCellType() + ")");
    }

    void inspectPtgs(String string) {
        FormulaParser formulaParser = new FormulaParser(string, this.workbook);
        formulaParser.parse();
        Ptg[] ptgArray = formulaParser.getRPNPtg();
        System.out.println("<ptg-group>");
        int n = ptgArray.length;
        for (int i = 0; i < n; ++i) {
            System.out.println("<ptg>");
            System.out.println(ptgArray[i]);
            if (ptgArray[i] instanceof OperationPtg) {
                System.out.println("numoperands: " + ((OperationPtg)ptgArray[i]).getNumberOfOperands());
            }
            System.out.println("</ptg>");
        }
        System.out.println("</ptg-group>");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        VALUE_EVALS_MAP.put(class$com$fr$third$org$apache$poi$hssf$record$formula$BoolPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$BoolPtg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.BoolPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$BoolPtg, class$com$fr$third$org$apache$poi$hssf$record$formula$eval$BoolEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$BoolEval = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$BoolEval);
        VALUE_EVALS_MAP.put(class$com$fr$third$org$apache$poi$hssf$record$formula$IntPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$IntPtg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.IntPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$IntPtg, class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval);
        VALUE_EVALS_MAP.put(class$com$fr$third$org$apache$poi$hssf$record$formula$NumberPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$NumberPtg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.NumberPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$NumberPtg, class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$NumberEval);
        VALUE_EVALS_MAP.put(class$com$fr$third$org$apache$poi$hssf$record$formula$StringPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$StringPtg = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.StringPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$StringPtg, class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval = HSSFFormulaEvaluator.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval);
    }

    public static final class CellValue {
        private int cellType;
        private HSSFRichTextString richTextStringValue;
        private double numberValue;
        private boolean booleanValue;
        private byte errorValue;

        public CellValue(int n) {
            this.cellType = n;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public void setBooleanValue(boolean bl) {
            this.booleanValue = bl;
        }

        public double getNumberValue() {
            return this.numberValue;
        }

        public void setNumberValue(double d) {
            this.numberValue = d;
        }

        public String getStringValue() {
            return this.richTextStringValue.getString();
        }

        public void setStringValue(String string) {
            this.richTextStringValue = new HSSFRichTextString(string);
        }

        public int getCellType() {
            return this.cellType;
        }

        public byte getErrorValue() {
            return this.errorValue;
        }

        public void setErrorValue(byte by) {
            this.errorValue = by;
        }

        public HSSFRichTextString getRichTextStringValue() {
            return this.richTextStringValue;
        }

        public void setRichTextStringValue(HSSFRichTextString hSSFRichTextString) {
            this.richTextStringValue = hSSFRichTextString;
        }
    }
}

