/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.FooterRecord;

public class HSSFFooter {
    FooterRecord footerRecord;
    String left;
    String center;
    String right;

    protected HSSFFooter(FooterRecord footerRecord) {
        this.footerRecord = footerRecord;
        String string = footerRecord.getFooter();
        block5: while (string != null && string.length() > 1) {
            int n = string.length();
            switch (string.substring(1, 2).charAt(0)) {
                case 'L': {
                    if (string.indexOf("&C") >= 0) {
                        n = Math.min(n, string.indexOf("&C"));
                    }
                    if (string.indexOf("&R") >= 0) {
                        n = Math.min(n, string.indexOf("&R"));
                    }
                    this.left = string.substring(2, n);
                    string = string.substring(n);
                    continue block5;
                }
                case 'C': {
                    if (string.indexOf("&L") >= 0) {
                        n = Math.min(n, string.indexOf("&L"));
                    }
                    if (string.indexOf("&R") >= 0) {
                        n = Math.min(n, string.indexOf("&R"));
                    }
                    this.center = string.substring(2, n);
                    string = string.substring(n);
                    continue block5;
                }
                case 'R': {
                    if (string.indexOf("&C") >= 0) {
                        n = Math.min(n, string.indexOf("&C"));
                    }
                    if (string.indexOf("&L") >= 0) {
                        n = Math.min(n, string.indexOf("&L"));
                    }
                    this.right = string.substring(2, n);
                    string = string.substring(n);
                    continue block5;
                }
            }
            string = null;
        }
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String string) {
        this.left = string;
        this.createFooterString();
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String string) {
        this.center = string;
        this.createFooterString();
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String string) {
        this.right = string;
        this.createFooterString();
    }

    private void createFooterString() {
        this.footerRecord.setFooter("&C" + (this.center == null ? "" : this.center) + "&L" + (this.left == null ? "" : this.left) + "&R" + (this.right == null ? "" : this.right));
        this.footerRecord.setFooterLength((byte)this.footerRecord.getFooter().length());
    }

    public static String fontSize(short s) {
        return "&" + s;
    }

    public static String font(String string, String string2) {
        return "&\"" + string + "," + string2 + "\"";
    }

    public static String page() {
        return "&P";
    }

    public static String numPages() {
        return "&N";
    }

    public static String date() {
        return "&D";
    }

    public static String time() {
        return "&T";
    }

    public static String file() {
        return "&F";
    }

    public static String tab() {
        return "&A";
    }

    public static String startUnderline() {
        return "&U";
    }

    public static String endUnderline() {
        return "&U";
    }

    public static String startDoubleUnderline() {
        return "&E";
    }

    public static String endDoubleUnderline() {
        return "&E";
    }
}

