/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.FontRecord;

public class HSSFFont {
    public static final String FONT_ARIAL = "Arial";
    public static final short BOLDWEIGHT_NORMAL = 400;
    public static final short BOLDWEIGHT_BOLD = 700;
    public static final short COLOR_NORMAL = Short.MAX_VALUE;
    public static final short COLOR_RED = 10;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    public static final byte ANSI_CHARSET = 0;
    public static final byte DEFAULT_CHARSET = 1;
    public static final byte SYMBOL_CHARSET = 2;
    private FontRecord font;
    private short index;

    protected HSSFFont(short s, FontRecord fontRecord) {
        this.font = fontRecord;
        this.index = s;
    }

    public void setFontName(String string) {
        this.font.setFontName(string);
        this.font.setFontNameLength((byte)string.length());
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public short getIndex() {
        return this.index;
    }

    public void setFontHeight(short s) {
        this.font.setFontHeight(s);
    }

    public void setFontHeightInPoints(short s) {
        this.font.setFontHeight((short)(s * 20));
    }

    public short getFontHeight() {
        return this.font.getFontHeight();
    }

    public short getFontHeightInPoints() {
        return (short)(this.font.getFontHeight() / 20);
    }

    public void setItalic(boolean bl) {
        this.font.setItalic(bl);
    }

    public boolean getItalic() {
        return this.font.isItalic();
    }

    public void setStrikeout(boolean bl) {
        this.font.setStrikeout(bl);
    }

    public boolean getStrikeout() {
        return this.font.isStruckout();
    }

    public void setColor(short s) {
        this.font.setColorPaletteIndex(s);
    }

    public short getColor() {
        return this.font.getColorPaletteIndex();
    }

    public void setBoldweight(short s) {
        this.font.setBoldWeight(s);
    }

    public short getBoldweight() {
        return this.font.getBoldWeight();
    }

    public void setTypeOffset(short s) {
        this.font.setSuperSubScript(s);
    }

    public short getTypeOffset() {
        return this.font.getSuperSubScript();
    }

    public void setUnderline(byte by) {
        this.font.setUnderline(by);
    }

    public byte getUnderline() {
        return this.font.getUnderline();
    }

    public byte getCharSet() {
        return this.font.getCharset();
    }

    public void setCharSet(byte by) {
        this.font.setCharset(by);
    }

    public String toString() {
        return "com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont{" + this.font + "}";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.font == null ? 0 : this.font.hashCode());
        n = 31 * n + this.index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof HSSFFont) {
            HSSFFont hSSFFont = (HSSFFont)object;
            if (this.font == null ? hSSFFont.font != null : !this.font.equals(hSSFFont.font)) {
                return false;
            }
            return this.index == hSSFFont.index;
        }
        return false;
    }
}

