/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class HSSFDateUtil {
    private static final int BAD_DATE = -1;
    private static final long DAY_MILLISECONDS = 86400000L;

    private HSSFDateUtil() {
    }

    public static double getExcelDate(Date date) {
        return HSSFDateUtil.getExcelDate(date, false);
    }

    public static double getExcelDate(Date date, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return HSSFDateUtil.internalGetExcelDate(gregorianCalendar, bl);
    }

    public static double getExcelDate(Calendar calendar, boolean bl) {
        return HSSFDateUtil.internalGetExcelDate((Calendar)calendar.clone(), bl);
    }

    private static double internalGetExcelDate(Calendar calendar, boolean bl) {
        if (!bl && calendar.get(1) < 1900 || bl && calendar.get(1) < 1904) {
            return -1.0;
        }
        double d = (double)(((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14)) / 8.64E7;
        Calendar calendar2 = HSSFDateUtil.dayStart(calendar);
        double d2 = d + (double)HSSFDateUtil.absoluteDay(calendar2, bl);
        if (!bl && d2 >= 60.0) {
            d2 += 1.0;
        } else if (bl) {
            d2 -= 1.0;
        }
        return d2;
    }

    public static Date getJavaDate(double d) {
        return HSSFDateUtil.getJavaDate(d, false);
    }

    public static Date getJavaDate(double d, boolean bl) {
        if (HSSFDateUtil.isValidExcelDate(d)) {
            int n = 1900;
            int n2 = -1;
            int n3 = (int)Math.floor(d);
            if (bl) {
                n = 1904;
                n2 = 1;
            } else if (n3 < 61) {
                n2 = 0;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, 0, n3 + n2);
            int n4 = (int)((d - Math.floor(d)) * 8.64E7 + 0.5);
            gregorianCalendar.set(14, n4);
            return gregorianCalendar.getTime();
        }
        return null;
    }

    public static boolean isADateFormat(int n, String string) {
        if (HSSFDateUtil.isInternalDateFormat(n)) {
            return true;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = string;
        string2 = string2.replaceAll("\\\\-", "-");
        string2 = string2.replaceAll("\\\\,", ",");
        string2 = string2.replaceAll("\\\\ ", " ");
        string2 = string2.replaceAll(";@", "");
        string2 = string2.replaceAll("^\\[\\$\\-.*?\\]", "");
        return (string2 = string2.replaceAll("^\\[[a-zA-Z]+\\]", "")).matches("^[yYmMdDhHsS\\-/,. :]+[ampAMP]*$");
    }

    public static boolean isInternalDateFormat(int n) {
        boolean bl = false;
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isCellDateFormatted(HSSFCell hSSFCell) {
        if (hSSFCell == null) {
            return false;
        }
        boolean bl = false;
        double d = hSSFCell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate(d)) {
            HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
            short s = hSSFCellStyle.getDataFormat();
            String string = hSSFCellStyle.getDataFormatString(hSSFCell.getBoundWorkbook());
            bl = HSSFDateUtil.isADateFormat(s, string);
        }
        return bl;
    }

    public static boolean isCellInternalDateFormatted(HSSFCell hSSFCell) {
        if (hSSFCell == null) {
            return false;
        }
        boolean bl = false;
        double d = hSSFCell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate(d)) {
            HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
            short s = hSSFCellStyle.getDataFormat();
            bl = HSSFDateUtil.isInternalDateFormat(s);
        }
        return bl;
    }

    public static boolean isValidExcelDate(double d) {
        return d > -4.9E-324;
    }

    static int absoluteDay(Calendar calendar, boolean bl) {
        return calendar.get(6) + HSSFDateUtil.daysInPriorYears(calendar.get(1), bl);
    }

    private static int daysInPriorYears(int n, boolean bl) {
        if (!bl && n < 1900 || bl && n < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int n2 = n - 1;
        int n3 = n2 / 4 - n2 / 100 + n2 / 400 - 460;
        return 365 * (n - (bl ? 1904 : 1900)) + n3;
    }

    private static Calendar dayStart(Calendar calendar) {
        calendar.get(11);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.get(11);
        return calendar;
    }
}

