/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.FormatRecord;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class HSSFDataFormat {
    private static List builtinFormats = HSSFDataFormat.createBuiltinFormats();
    private Vector formats = new Vector();
    private Workbook workbook;
    private boolean movedBuiltins = false;

    public HSSFDataFormat(Workbook workbook) {
        this.workbook = workbook;
        Iterator iterator = workbook.getFormats().iterator();
        while (iterator.hasNext()) {
            FormatRecord formatRecord = (FormatRecord)iterator.next();
            if (this.formats.size() < formatRecord.getIndexCode() + 1) {
                this.formats.setSize(formatRecord.getIndexCode() + 1);
            }
            this.formats.set(formatRecord.getIndexCode(), formatRecord.getFormatString());
        }
    }

    private static synchronized List createBuiltinFormats() {
        Vector<String> vector = new Vector<String>();
        vector.add(0, "General");
        vector.add(1, "0");
        vector.add(2, "0.00");
        vector.add(3, "#,##0");
        vector.add(4, "#,##0.00");
        vector.add(5, "($#,##0_);($#,##0)");
        vector.add(6, "($#,##0_);[Red]($#,##0)");
        vector.add(7, "($#,##0.00);($#,##0.00)");
        vector.add(8, "($#,##0.00_);[Red]($#,##0.00)");
        vector.add(9, "0%");
        vector.add(10, "0.00%");
        vector.add(11, "0.00E+00");
        vector.add(12, "# ?/?");
        vector.add(13, "# ??/??");
        vector.add(14, "m/d/yy");
        vector.add(15, "d-mmm-yy");
        vector.add(16, "d-mmm");
        vector.add(17, "mmm-yy");
        vector.add(18, "h:mm AM/PM");
        vector.add(19, "h:mm:ss AM/PM");
        vector.add(20, "h:mm");
        vector.add(21, "h:mm:ss");
        vector.add(22, "m/d/yy h:mm");
        vector.add(23, "0x17");
        vector.add(24, "0x18");
        vector.add(25, "0x19");
        vector.add(26, "0x1a");
        vector.add(27, "0x1b");
        vector.add(28, "0x1c");
        vector.add(29, "0x1d");
        vector.add(30, "0x1e");
        vector.add(31, "0x1f");
        vector.add(32, "0x20");
        vector.add(33, "0x21");
        vector.add(34, "0x22");
        vector.add(35, "0x23");
        vector.add(36, "0x24");
        vector.add(37, "(#,##0_);(#,##0)");
        vector.add(38, "(#,##0_);[Red](#,##0)");
        vector.add(39, "(#,##0.00_);(#,##0.00)");
        vector.add(40, "(#,##0.00_);[Red](#,##0.00)");
        vector.add(41, "_(*#,##0_);_(*(#,##0);_(* \"-\"_);_(@_)");
        vector.add(42, "_($*#,##0_);_($*(#,##0);_($* \"-\"_);_(@_)");
        vector.add(43, "_(*#,##0.00_);_(*(#,##0.00);_(*\"-\"??_);_(@_)");
        vector.add(44, "_($*#,##0.00_);_($*(#,##0.00);_($*\"-\"??_);_(@_)");
        vector.add(45, "mm:ss");
        vector.add(46, "[h]:mm:ss");
        vector.add(47, "mm:ss.0");
        vector.add(48, "##0.0E+0");
        vector.add(49, "@");
        return vector;
    }

    public static List getBuiltinFormats() {
        return builtinFormats;
    }

    public static short getBuiltinFormat(String string) {
        if (string.toUpperCase().equals("TEXT")) {
            string = "@";
        }
        int n = -1;
        for (int n2 = 0; n2 <= 49; n2 = (int)((short)(n2 + 1))) {
            String string2 = (String)builtinFormats.get(n2);
            if (string2 == null || !string2.equals(string)) continue;
            n = n2;
            break;
        }
        return (short)n;
    }

    public short getFormat(String string) {
        int n;
        ListIterator listIterator;
        if (string.toUpperCase().equals("TEXT")) {
            string = "@";
        }
        if (!this.movedBuiltins) {
            listIterator = builtinFormats.listIterator();
            while (listIterator.hasNext()) {
                n = listIterator.nextIndex();
                if (this.formats.size() < n + 1) {
                    this.formats.setSize(n + 1);
                }
                this.formats.set(n, listIterator.next());
            }
            this.movedBuiltins = true;
        }
        listIterator = this.formats.listIterator();
        while (listIterator.hasNext()) {
            n = listIterator.nextIndex();
            if (!string.equals(listIterator.next())) continue;
            return (short)n;
        }
        n = this.workbook.getFormat(string, true);
        if (this.formats.size() <= n) {
            this.formats.setSize(n + 1);
        }
        this.formats.set(n, string);
        return (short)n;
    }

    public String getFormat(short s) {
        if (this.movedBuiltins) {
            return (String)this.formats.get(s);
        }
        return (String)(builtinFormats.size() > s && builtinFormats.get(s) != null ? builtinFormats.get(s) : this.formats.get(s));
    }

    public static String getBuiltinFormat(short s) {
        return (String)builtinFormats.get(s);
    }

    public static int getNumberOfBuiltinBuiltinFormats() {
        return builtinFormats.size();
    }
}

