/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.CFHeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.CFRuleRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.record.cf.CellRange;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.Region;

public final class HSSFConditionalFormatting {
    private final HSSFWorkbook _workbook;
    private final CFRecordsAggregate cfAggregate;

    HSSFConditionalFormatting(HSSFWorkbook hSSFWorkbook, CFRecordsAggregate cFRecordsAggregate) {
        if (hSSFWorkbook == null) {
            throw new IllegalArgumentException("workbook must not be null");
        }
        if (cFRecordsAggregate == null) {
            throw new IllegalArgumentException("cfAggregate must not be null");
        }
        this._workbook = hSSFWorkbook;
        this.cfAggregate = cFRecordsAggregate;
    }

    CFRecordsAggregate getCFRecordsAggregate() {
        return this.cfAggregate;
    }

    public Region[] getFormattingRegions() {
        CFHeaderRecord cFHeaderRecord = this.cfAggregate.getHeader();
        CellRange[] cellRangeArray = cFHeaderRecord.getCellRanges();
        return CellRange.convertCellRangesToRegions(cellRangeArray);
    }

    public void setRule(int n, HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        this.cfAggregate.setRule(n, hSSFConditionalFormattingRule.getCfRuleRecord());
    }

    public void addRule(HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        this.cfAggregate.addRule(hSSFConditionalFormattingRule.getCfRuleRecord());
    }

    public HSSFConditionalFormattingRule getRule(int n) {
        CFRuleRecord cFRuleRecord = this.cfAggregate.getRule(n);
        return new HSSFConditionalFormattingRule(this._workbook, cFRuleRecord);
    }

    public int getNumberOfRules() {
        return this.cfAggregate.getNumberOfRules();
    }

    public String toString() {
        return this.cfAggregate.toString();
    }
}

