/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.TextObjectRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;

public class HSSFComment
extends HSSFTextbox {
    private boolean visible;
    private short col;
    private short row;
    private String author;
    private NoteRecord note = null;
    private TextObjectRecord txo = null;

    public HSSFComment(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        this.setShapeType(25);
        this.fillColor = 0x8000050;
        this.visible = false;
        this.author = "";
    }

    protected HSSFComment(NoteRecord noteRecord, TextObjectRecord textObjectRecord) {
        this((HSSFShape)null, (HSSFAnchor)null);
        this.txo = textObjectRecord;
        this.note = noteRecord;
    }

    public void setVisible(boolean bl) {
        if (this.note != null) {
            this.note.setFlags(bl ? (short)2 : 0);
        }
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        if (this.note != null) {
            this.note.setRow((short)n);
        }
        this.row = (short)n;
    }

    public short getColumn() {
        return this.col;
    }

    public void setColumn(short s) {
        if (this.note != null) {
            this.note.setColumn(s);
        }
        this.col = s;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        if (this.note != null) {
            this.note.setAuthor(string);
        }
        this.author = string;
    }

    public void setString(HSSFRichTextString hSSFRichTextString) {
        if (hSSFRichTextString.numFormattingRuns() == 0) {
            hSSFRichTextString.applyFont((short)0);
        }
        if (this.txo != null) {
            int n = (hSSFRichTextString.numFormattingRuns() + 1) * 8;
            this.txo.setFormattingRunLength((short)n);
            this.txo.setTextLength((short)hSSFRichTextString.length());
            this.txo.setStr(hSSFRichTextString);
        }
        super.setString(hSSFRichTextString);
    }
}

