/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;

public class HSSFClientAnchor
extends HSSFAnchor {
    short col1;
    int row1;
    short col2;
    int row2;
    int anchorType;

    public HSSFClientAnchor() {
    }

    public HSSFClientAnchor(int n, int n2, int n3, int n4, short s, int n5, short s2, int n6) {
        super(n, n2, n3, n4);
        this.checkRange(n, 0, 1023, "dx1");
        this.checkRange(n3, 0, 1023, "dx2");
        this.checkRange(n2, 0, 255, "dy1");
        this.checkRange(n4, 0, 255, "dy2");
        this.checkRange(s, 0, 255, "col1");
        this.checkRange(s2, 0, 255, "col2");
        this.checkRange(n5, 0, 65280, "row1");
        this.checkRange(n6, 0, 65280, "row2");
        this.col1 = s;
        this.row1 = n5;
        this.col2 = s2;
        this.row2 = n6;
    }

    public float getAnchorHeightInPoints(HSSFSheet hSSFSheet) {
        int n = this.getDy1();
        int n2 = this.getDy2();
        int n3 = Math.min(this.getRow1(), this.getRow2());
        int n4 = Math.max(this.getRow1(), this.getRow2());
        float f = 0.0f;
        if (n3 == n4) {
            f = (float)(n2 - n) / 256.0f * this.getRowHeightInPoints(hSSFSheet, n4);
        } else {
            f += (256.0f - (float)n) / 256.0f * this.getRowHeightInPoints(hSSFSheet, n3);
            for (int i = n3 + 1; i < n4; ++i) {
                f += this.getRowHeightInPoints(hSSFSheet, i);
            }
            f += (float)n2 / 256.0f * this.getRowHeightInPoints(hSSFSheet, n4);
        }
        return f;
    }

    private float getRowHeightInPoints(HSSFSheet hSSFSheet, int n) {
        HSSFRow hSSFRow = hSSFSheet.getRow(n);
        if (hSSFRow == null) {
            return hSSFSheet.getDefaultRowHeightInPoints();
        }
        return hSSFRow.getHeightInPoints();
    }

    public short getCol1() {
        return this.col1;
    }

    public void setCol1(short s) {
        this.checkRange(s, 0, 255, "col1");
        this.col1 = s;
    }

    public short getCol2() {
        return this.col2;
    }

    public void setCol2(short s) {
        this.checkRange(s, 0, 255, "col2");
        this.col2 = s;
    }

    public int getRow1() {
        return this.row1;
    }

    public void setRow1(int n) {
        this.checkRange(n, 0, 65536, "row1");
        this.row1 = n;
    }

    public int getRow2() {
        return this.row2;
    }

    public void setRow2(int n) {
        this.checkRange(n, 0, 65536, "row2");
        this.row2 = n;
    }

    public void setAnchor(short s, int n, int n2, int n3, short s2, int n4, int n5, int n6) {
        this.checkRange(this.dx1, 0, 1023, "dx1");
        this.checkRange(this.dx2, 0, 1023, "dx2");
        this.checkRange(this.dy1, 0, 255, "dy1");
        this.checkRange(this.dy2, 0, 255, "dy2");
        this.checkRange(s, 0, 255, "col1");
        this.checkRange(s2, 0, 255, "col2");
        this.checkRange(n, 0, 65280, "row1");
        this.checkRange(n4, 0, 65280, "row2");
        this.col1 = s;
        this.row1 = n;
        this.dx1 = n2;
        this.dy1 = n3;
        this.col2 = s2;
        this.row2 = n4;
        this.dx2 = n5;
        this.dy2 = n6;
    }

    public boolean isHorizontallyFlipped() {
        if (this.col1 == this.col2) {
            return this.dx1 > this.dx2;
        }
        return this.col1 > this.col2;
    }

    public boolean isVerticallyFlipped() {
        if (this.row1 == this.row2) {
            return this.dy1 > this.dy2;
        }
        return this.row1 > this.row2;
    }

    public int getAnchorType() {
        return this.anchorType;
    }

    public void setAnchorType(int n) {
        this.anchorType = n;
    }

    private void checkRange(int n, int n2, int n3, String string) {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException(string + " must be between " + n2 + " and " + n3);
        }
    }
}

