/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.BlankRecord;
import com.fr.third.org.apache.poi.hssf.record.BoolErrRecord;
import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtendedFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.HyperlinkRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.org.apache.poi.hssf.record.SubRecord;
import com.fr.third.org.apache.poi.hssf.record.TextObjectRecord;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFHyperlink;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class HSSFCell {
    public static final int CELL_TYPE_NUMERIC = 0;
    public static final int CELL_TYPE_STRING = 1;
    public static final int CELL_TYPE_FORMULA = 2;
    public static final int CELL_TYPE_BLANK = 3;
    public static final int CELL_TYPE_BOOLEAN = 4;
    public static final int CELL_TYPE_ERROR = 5;
    public static final short ENCODING_UNCHANGED = -1;
    public static final short ENCODING_COMPRESSED_UNICODE = 0;
    public static final short ENCODING_UTF_16 = 1;
    private int cellType;
    private HSSFRichTextString stringValue;
    private short encoding = (short)-1;
    private HSSFWorkbook book;
    private Sheet sheet;
    private CellValueRecordInterface record;
    private HSSFComment comment;

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, Sheet sheet, int n, short s) {
        this.checkBounds(s);
        this.stringValue = null;
        this.book = hSSFWorkbook;
        this.sheet = sheet;
        short s2 = sheet.getXFIndexForColAt(s);
        this.setCellType(3, false, n, s, s2);
    }

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, Sheet sheet, int n, short s, int n2) {
        this.checkBounds(s);
        this.cellType = -1;
        this.stringValue = null;
        this.book = hSSFWorkbook;
        this.sheet = sheet;
        short s2 = sheet.getXFIndexForColAt(s);
        this.setCellType(n2, false, n, s, s2);
    }

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, Sheet sheet, int n, CellValueRecordInterface cellValueRecordInterface) {
        this.record = cellValueRecordInterface;
        this.cellType = this.determineType(cellValueRecordInterface);
        this.stringValue = null;
        this.book = hSSFWorkbook;
        this.sheet = sheet;
        switch (this.cellType) {
            case 1: {
                this.stringValue = new HSSFRichTextString(hSSFWorkbook.getWorkbook(), (LabelSSTRecord)cellValueRecordInterface);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this.stringValue = new HSSFRichTextString(((FormulaRecordAggregate)cellValueRecordInterface).getStringValue());
            }
        }
        ExtendedFormatRecord extendedFormatRecord = hSSFWorkbook.getWorkbook().getExFormatAt(cellValueRecordInterface.getXFIndex());
        this.setCellStyle(new HSSFCellStyle(cellValueRecordInterface.getXFIndex(), extendedFormatRecord, hSSFWorkbook));
    }

    private HSSFCell() {
    }

    private int determineType(CellValueRecordInterface cellValueRecordInterface) {
        Record record = (Record)((Object)cellValueRecordInterface);
        short s = record.getSid();
        int n = 0;
        switch (s) {
            case 515: {
                n = 0;
                break;
            }
            case 513: {
                n = 3;
                break;
            }
            case 253: {
                n = 1;
                break;
            }
            case -2000: {
                n = 2;
                break;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                n = boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        return n;
    }

    protected Workbook getBoundWorkbook() {
        return this.book.getWorkbook();
    }

    public void setCellNum(short s) {
        this.record.setColumn(s);
    }

    protected void updateCellNum(short s) {
        this.record.setColumn(s);
    }

    public short getCellNum() {
        return this.record.getColumn();
    }

    public void setCellType(int n) {
        int n2 = this.record.getRow();
        short s = this.record.getColumn();
        short s2 = this.record.getXFIndex();
        this.setCellType(n, true, n2, s, s2);
    }

    private void setCellType(int n, boolean bl, int n2, short s, short s2) {
        if (n > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (n) {
            case 2: {
                FormulaRecordAggregate formulaRecordAggregate = null;
                formulaRecordAggregate = n != this.cellType ? new FormulaRecordAggregate(new FormulaRecord(), null) : (FormulaRecordAggregate)this.record;
                formulaRecordAggregate.setColumn(s);
                if (bl) {
                    formulaRecordAggregate.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                formulaRecordAggregate.setXFIndex(s2);
                formulaRecordAggregate.setRow(n2);
                this.record = formulaRecordAggregate;
                break;
            }
            case 0: {
                NumberRecord numberRecord = null;
                numberRecord = n != this.cellType ? new NumberRecord() : (NumberRecord)this.record;
                numberRecord.setColumn(s);
                if (bl) {
                    numberRecord.setValue(this.getNumericCellValue());
                }
                numberRecord.setXFIndex(s2);
                numberRecord.setRow(n2);
                this.record = numberRecord;
                break;
            }
            case 1: {
                LabelSSTRecord labelSSTRecord = null;
                labelSSTRecord = n != this.cellType ? new LabelSSTRecord() : (LabelSSTRecord)this.record;
                labelSSTRecord.setColumn(s);
                labelSSTRecord.setRow(n2);
                labelSSTRecord.setXFIndex(s2);
                if (bl && this.getStringCellValue() != null && !this.getStringCellValue().equals("")) {
                    int n3 = 0;
                    UnicodeString unicodeString = this.getRichStringCellValue().getUnicodeString();
                    n3 = this.book.getWorkbook().addSSTString(unicodeString);
                    labelSSTRecord.setSSTIndex(n3);
                    this.getRichStringCellValue().setUnicodeString(this.book.getWorkbook().getSSTString(n3));
                }
                this.record = labelSSTRecord;
                break;
            }
            case 3: {
                BlankRecord blankRecord = null;
                blankRecord = n != this.cellType ? new BlankRecord() : (BlankRecord)this.record;
                blankRecord.setColumn(s);
                blankRecord.setXFIndex(s2);
                blankRecord.setRow(n2);
                this.record = blankRecord;
                break;
            }
            case 4: {
                BoolErrRecord boolErrRecord = null;
                boolErrRecord = n != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                boolErrRecord.setColumn(s);
                if (bl) {
                    boolErrRecord.setValue(this.convertCellValueToBoolean());
                }
                boolErrRecord.setXFIndex(s2);
                boolErrRecord.setRow(n2);
                this.record = boolErrRecord;
                break;
            }
            case 5: {
                BoolErrRecord boolErrRecord = null;
                boolErrRecord = n != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                boolErrRecord.setColumn(s);
                if (bl) {
                    boolErrRecord.setValue(this.getErrorCellValue());
                }
                boolErrRecord.setXFIndex(s2);
                boolErrRecord.setRow(n2);
                this.record = boolErrRecord;
            }
        }
        if (n != this.cellType && this.cellType != -1) {
            int n4 = this.sheet.getLoc();
            this.sheet.replaceValueRecord(this.record);
            this.sheet.setLoc(n4);
        }
        this.cellType = n;
    }

    public int getCellType() {
        return this.cellType;
    }

    public void setCellValue(double d) {
        int n = this.record.getRow();
        short s = this.record.getColumn();
        short s2 = this.record.getXFIndex();
        if (this.cellType != 0 && this.cellType != 2) {
            this.setCellType(0, false, n, s, s2);
        }
        if (this.record instanceof FormulaRecordAggregate) {
            ((FormulaRecordAggregate)this.record).getFormulaRecord().setValue(d);
        } else {
            ((NumberRecord)this.record).setValue(d);
        }
    }

    public void setCellValue(Date date) {
        this.setCellValue(HSSFDateUtil.getExcelDate(date, this.book.getWorkbook().isUsing1904DateWindowing()));
    }

    public void setCellValue(Calendar calendar) {
        this.setCellValue(HSSFDateUtil.getExcelDate(calendar, this.book.getWorkbook().isUsing1904DateWindowing()));
    }

    public void setCellValue(String string) {
        HSSFRichTextString hSSFRichTextString = new HSSFRichTextString(string);
        this.setCellValue(hSSFRichTextString);
    }

    public void setCellValue(HSSFRichTextString hSSFRichTextString) {
        int n = this.record.getRow();
        short s = this.record.getColumn();
        short s2 = this.record.getXFIndex();
        if (hSSFRichTextString == null) {
            this.setCellType(3, false, n, s, s2);
            return;
        }
        if (this.cellType == 2) {
            FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this.record;
            StringRecord stringRecord = new StringRecord();
            stringRecord.setString(hSSFRichTextString.getString());
            formulaRecordAggregate.setStringRecord(stringRecord);
            return;
        }
        if (this.cellType != 1) {
            this.setCellType(1, false, n, s, s2);
        }
        int n2 = 0;
        UnicodeString unicodeString = hSSFRichTextString.getUnicodeString();
        n2 = this.book.getWorkbook().addSSTString(unicodeString);
        ((LabelSSTRecord)this.record).setSSTIndex(n2);
        this.stringValue = hSSFRichTextString;
        this.stringValue.setWorkbookReferences(this.book.getWorkbook(), (LabelSSTRecord)this.record);
        this.stringValue.setUnicodeString(this.book.getWorkbook().getSSTString(n2));
    }

    public void setCellFormula(String string) {
        int n = this.record.getRow();
        short s = this.record.getColumn();
        short s2 = this.record.getXFIndex();
        if (string == null) {
            this.setCellType(3, false, n, s, s2);
        } else {
            int n2;
            this.setCellType(2, false, n, s, s2);
            FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this.record;
            FormulaRecord formulaRecord = formulaRecordAggregate.getFormulaRecord();
            formulaRecord.setOptions((short)2);
            formulaRecord.setValue(0.0);
            if (formulaRecordAggregate.getXFIndex() == 0) {
                formulaRecordAggregate.setXFIndex((short)15);
            }
            FormulaParser formulaParser = new FormulaParser(string, this.book);
            formulaParser.parse();
            Ptg[] ptgArray = formulaParser.getRPNPtg();
            int n3 = 0;
            int n4 = formulaRecord.getNumberOfExpressionTokens();
            for (n2 = 0; n2 < n4; ++n2) {
                formulaRecord.popExpressionToken();
            }
            for (n2 = 0; n2 < ptgArray.length; ++n2) {
                n3 += ptgArray[n2].getSize();
                formulaRecord.pushExpressionToken(ptgArray[n2]);
            }
            formulaRecordAggregate.getFormulaRecord().setExpressionLength((short)n3);
        }
    }

    public String getCellFormula() {
        String string = FormulaParser.toFormulaString(this.book, ((FormulaRecordAggregate)this.record).getFormulaRecord().getParsedExpression());
        return string;
    }

    public double getNumericCellValue() {
        if (this.cellType == 3) {
            return 0.0;
        }
        if (this.cellType == 1) {
            throw new NumberFormatException("You cannot get a numeric value from a String based cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a numeric value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a numeric value from an error cell");
        }
        if (this.cellType == 0) {
            return ((NumberRecord)this.record).getValue();
        }
        if (this.cellType == 2) {
            return ((FormulaRecordAggregate)this.record).getFormulaRecord().getValue();
        }
        throw new NumberFormatException("Unknown Record Type in Cell:" + this.cellType);
    }

    public Date getDateCellValue() {
        if (this.cellType == 3) {
            return null;
        }
        if (this.cellType == 1) {
            throw new NumberFormatException("You cannot get a date value from a String based cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a date value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a date value from an error cell");
        }
        double d = this.getNumericCellValue();
        if (this.book.getWorkbook().isUsing1904DateWindowing()) {
            return HSSFDateUtil.getJavaDate(d, true);
        }
        return HSSFDateUtil.getJavaDate(d, false);
    }

    public String getStringCellValue() {
        HSSFRichTextString hSSFRichTextString = this.getRichStringCellValue();
        return hSSFRichTextString.getString();
    }

    public HSSFRichTextString getRichStringCellValue() {
        if (this.cellType == 3) {
            return new HSSFRichTextString("");
        }
        if (this.cellType == 0) {
            throw new NumberFormatException("You cannot get a string value from a numeric cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a string value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a string value from an error cell");
        }
        if (this.cellType == 2 && this.stringValue == null) {
            return new HSSFRichTextString("");
        }
        return this.stringValue;
    }

    public void setCellValue(boolean bl) {
        int n = this.record.getRow();
        short s = this.record.getColumn();
        short s2 = this.record.getXFIndex();
        if (this.cellType != 4 && this.cellType != 2) {
            this.setCellType(4, false, n, s, s2);
        }
        ((BoolErrRecord)this.record).setValue(bl);
    }

    public void setCellErrorValue(byte by) {
        int n = this.record.getRow();
        short s = this.record.getColumn();
        short s2 = this.record.getXFIndex();
        if (this.cellType != 5) {
            this.setCellType(5, false, n, s, s2);
        }
        ((BoolErrRecord)this.record).setValue(by);
    }

    private boolean convertCellValueToBoolean() {
        switch (this.cellType) {
            case 4: {
                return ((BoolErrRecord)this.record).getBooleanValue();
            }
            case 1: {
                return Boolean.valueOf(((StringRecord)((Object)this.record)).getString());
            }
            case 0: {
                return ((NumberRecord)this.record).getValue() != 0.0;
            }
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + this.cellType + ")");
    }

    public boolean getBooleanCellValue() {
        if (this.cellType == 4) {
            return ((BoolErrRecord)this.record).getBooleanValue();
        }
        if (this.cellType == 3) {
            return false;
        }
        throw new NumberFormatException("You cannot get a boolean value from a non-boolean cell");
    }

    public byte getErrorCellValue() {
        if (this.cellType == 5) {
            return ((BoolErrRecord)this.record).getErrorValue();
        }
        if (this.cellType == 3) {
            return 0;
        }
        throw new NumberFormatException("You cannot get an error value from a non-error cell");
    }

    public void setCellStyle(HSSFCellStyle hSSFCellStyle) {
        this.record.setXFIndex(hSSFCellStyle.getIndex());
    }

    public HSSFCellStyle getCellStyle() {
        short s = this.record.getXFIndex();
        ExtendedFormatRecord extendedFormatRecord = this.book.getWorkbook().getExFormatAt(s);
        return new HSSFCellStyle(s, extendedFormatRecord, this.book);
    }

    public short getEncoding() {
        return this.encoding;
    }

    public void setEncoding(short s) {
        this.encoding = s;
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this.record;
    }

    private void checkBounds(int n) {
        if (n > 255) {
            throw new RuntimeException("You cannot have more than 255 columns in a given row (IV).  Because Excel can't handle it");
        }
        if (n < 0) {
            throw new RuntimeException("You cannot reference columns with an index of less then 0.");
        }
    }

    public void setAsActiveCell() {
        int n = this.record.getRow();
        short s = this.record.getColumn();
        this.sheet.setActiveCellRow(n);
        this.sheet.setActiveCellCol(s);
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return "#ERR" + this.getErrorCellValue();
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                    return simpleDateFormat.format(this.getDateCellValue());
                }
                return this.getNumericCellValue() + "";
            }
            case 1: {
                return this.getStringCellValue();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public void setCellComment(HSSFComment hSSFComment) {
        hSSFComment.setRow((short)this.record.getRow());
        hSSFComment.setColumn(this.record.getColumn());
        this.comment = hSSFComment;
    }

    public HSSFComment getCellComment() {
        if (this.comment == null) {
            this.comment = HSSFCell.findCellComment(this.sheet, this.record.getRow(), this.record.getColumn());
        }
        return this.comment;
    }

    protected static HSSFComment findCellComment(Sheet sheet, int n, int n2) {
        HSSFComment hSSFComment = null;
        HashMap<Integer, Record> hashMap = new HashMap<Integer, Record>();
        Iterator iterator = sheet.getRecords().iterator();
        block0: while (iterator.hasNext()) {
            CommonObjectDataSubRecord commonObjectDataSubRecord;
            Record record;
            Record record2;
            Record record3 = (Record)iterator.next();
            if (record3 instanceof NoteRecord) {
                record2 = (NoteRecord)record3;
                if (((NoteRecord)record2).getRow() != n || ((NoteRecord)record2).getColumn() != n2) continue;
                record = (TextObjectRecord)hashMap.get(new Integer(((NoteRecord)record2).getShapeId()));
                hSSFComment = new HSSFComment((NoteRecord)record2, (TextObjectRecord)record);
                hSSFComment.setRow(((NoteRecord)record2).getRow());
                hSSFComment.setColumn(((NoteRecord)record2).getColumn());
                hSSFComment.setAuthor(((NoteRecord)record2).getAuthor());
                hSSFComment.setVisible(((NoteRecord)record2).getFlags() == 2);
                hSSFComment.setString(((TextObjectRecord)record).getStr());
                break;
            }
            if (!(record3 instanceof ObjRecord) || !((record = (SubRecord)((ObjRecord)(record2 = (ObjRecord)record3)).getSubRecords().get(0)) instanceof CommonObjectDataSubRecord) || (commonObjectDataSubRecord = (CommonObjectDataSubRecord)record).getObjectType() != 25) continue;
            while (iterator.hasNext()) {
                record3 = (Record)iterator.next();
                if (!(record3 instanceof TextObjectRecord)) continue;
                hashMap.put(new Integer(commonObjectDataSubRecord.getObjectId()), record3);
                continue block0;
            }
        }
        return hSSFComment;
    }

    public HSSFHyperlink getHyperlink() {
        Iterator iterator = this.sheet.getRecords().iterator();
        while (iterator.hasNext()) {
            HyperlinkRecord hyperlinkRecord;
            Record record = (Record)iterator.next();
            if (!(record instanceof HyperlinkRecord) || (hyperlinkRecord = (HyperlinkRecord)record).getFirstColumn() != this.record.getColumn() || hyperlinkRecord.getFirstRow() != this.record.getRow()) continue;
            return new HSSFHyperlink(hyperlinkRecord);
        }
        return null;
    }

    public void setHyperlink(HSSFHyperlink hSSFHyperlink) {
        hSSFHyperlink.setFirstRow(this.record.getRow());
        hSSFHyperlink.setLastRow(this.record.getRow());
        hSSFHyperlink.setFirstColumn(this.record.getColumn());
        hSSFHyperlink.setLastColumn(this.record.getColumn());
        switch (hSSFHyperlink.getType()) {
            case 1: 
            case 3: {
                hSSFHyperlink.setLabel("url");
                break;
            }
            case 4: {
                hSSFHyperlink.setLabel("file");
                break;
            }
            case 2: {
                hSSFHyperlink.setLabel("place");
            }
        }
        int n = this.sheet.findFirstRecordLocBySid((short)10);
        this.sheet.getRecords().add(n, hSSFHyperlink.record);
    }
}

