/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.util.ArrayList;
import java.util.List;

final class EvaluationCycleDetector {
    private final List _evaluationFrames = new ArrayList();

    public boolean startEvaluate(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2) {
        CellEvaluationFrame cellEvaluationFrame = new CellEvaluationFrame(hSSFWorkbook, hSSFSheet, n, n2);
        if (this._evaluationFrames.contains(cellEvaluationFrame)) {
            return false;
        }
        this._evaluationFrames.add(cellEvaluationFrame);
        return true;
    }

    public void endEvaluate(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2) {
        CellEvaluationFrame cellEvaluationFrame;
        int n3 = this._evaluationFrames.size();
        if (n3 < 1) {
            throw new IllegalStateException("Call to endEvaluate without matching call to startEvaluate");
        }
        CellEvaluationFrame cellEvaluationFrame2 = new CellEvaluationFrame(hSSFWorkbook, hSSFSheet, n, n2);
        if (!cellEvaluationFrame2.equals(cellEvaluationFrame = (CellEvaluationFrame)this._evaluationFrames.get(--n3))) {
            throw new RuntimeException("Wrong cell specified. Corresponding startEvaluate() call was for cell {" + cellEvaluationFrame.formatAsString() + "} this endEvaluate() call is for cell {" + cellEvaluationFrame2.formatAsString() + "}");
        }
        this._evaluationFrames.remove(n3);
    }

    private static final class CellEvaluationFrame {
        private final HSSFWorkbook _workbook;
        private final HSSFSheet _sheet;
        private final int _srcRowNum;
        private final int _srcColNum;

        public CellEvaluationFrame(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2) {
            if (hSSFWorkbook == null) {
                throw new IllegalArgumentException("workbook must not be null");
            }
            if (hSSFSheet == null) {
                throw new IllegalArgumentException("sheet must not be null");
            }
            this._workbook = hSSFWorkbook;
            this._sheet = hSSFSheet;
            this._srcRowNum = n;
            this._srcColNum = n2;
        }

        public boolean equals(Object object) {
            CellEvaluationFrame cellEvaluationFrame = (CellEvaluationFrame)object;
            if (this._workbook != cellEvaluationFrame._workbook) {
                return false;
            }
            if (this._sheet != cellEvaluationFrame._sheet) {
                return false;
            }
            if (this._srcRowNum != cellEvaluationFrame._srcRowNum) {
                return false;
            }
            return this._srcColNum == cellEvaluationFrame._srcColNum;
        }

        public String formatAsString() {
            return "R=" + this._srcRowNum + " C=" + this._srcColNum + " ShIx=" + this._workbook.getSheetIndex(this._sheet);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this.formatAsString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

