/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.usermodel.FontDetails;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPolygon;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.usermodel.StaticFontMetrics;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public class EscherGraphics
extends Graphics {
    private HSSFShapeGroup escherGroup;
    private HSSFWorkbook workbook;
    private float verticalPointsPerPixel = 1.0f;
    private float verticalPixelsPerPoint;
    private Color foreground;
    private Color background = Color.white;
    private Font font;
    private static POILogger logger = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$usermodel$EscherGraphics == null ? (class$com$fr$third$org$apache$poi$hssf$usermodel$EscherGraphics = EscherGraphics.class$("com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics")) : class$com$fr$third$org$apache$poi$hssf$usermodel$EscherGraphics);
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$usermodel$EscherGraphics;

    public EscherGraphics(HSSFShapeGroup hSSFShapeGroup, HSSFWorkbook hSSFWorkbook, Color color, float f) {
        this.escherGroup = hSSFShapeGroup;
        this.workbook = hSSFWorkbook;
        this.verticalPointsPerPixel = f;
        this.verticalPixelsPerPoint = 1.0f / f;
        this.font = new Font("Arial", 0, 10);
        this.foreground = color;
    }

    EscherGraphics(HSSFShapeGroup hSSFShapeGroup, HSSFWorkbook hSSFWorkbook, Color color, Font font, float f) {
        this.escherGroup = hSSFShapeGroup;
        this.workbook = hSSFWorkbook;
        this.foreground = color;
        this.font = font;
        this.verticalPointsPerPixel = f;
        this.verticalPixelsPerPoint = 1.0f / f;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.foreground;
        this.setColor(this.background);
        this.fillRect(n, n2, n3, n4);
        this.setColor(color);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if (logger.check(5)) {
            logger.log(5, "clipRect not supported");
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (logger.check(5)) {
            logger.log(5, "copyArea not supported");
        }
    }

    public Graphics create() {
        EscherGraphics escherGraphics = new EscherGraphics(this.escherGroup, this.workbook, this.foreground, this.font, this.verticalPointsPerPixel);
        return escherGraphics;
    }

    public void dispose() {
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (logger.check(5)) {
            logger.log(5, "drawArc not supported");
        }
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (logger.check(5)) {
            logger.log(5, "drawImage not supported");
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (logger.check(5)) {
            logger.log(5, "drawImage not supported");
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n3, n4, 0);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5) {
        HSSFSimpleShape hSSFSimpleShape = this.escherGroup.createShape(new HSSFChildAnchor(n, n2, n3, n4));
        hSSFSimpleShape.setShapeType(1);
        hSSFSimpleShape.setLineWidth(n5);
        hSSFSimpleShape.setLineStyleColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        HSSFSimpleShape hSSFSimpleShape = this.escherGroup.createShape(new HSSFChildAnchor(n, n2, n + n3, n2 + n4));
        hSSFSimpleShape.setShapeType(3);
        hSSFSimpleShape.setLineWidth(0);
        hSSFSimpleShape.setLineStyleColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
        hSSFSimpleShape.setNoFill(true);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        int n2 = this.findBiggest(nArray);
        int n3 = this.findBiggest(nArray2);
        int n4 = this.findSmallest(nArray);
        int n5 = this.findSmallest(nArray2);
        HSSFPolygon hSSFPolygon = this.escherGroup.createPolygon(new HSSFChildAnchor(n4, n5, n2, n3));
        hSSFPolygon.setPolygonDrawArea(n2 - n4, n3 - n5);
        hSSFPolygon.setPoints(this.addToAll(nArray, -n4), this.addToAll(nArray2, -n5));
        hSSFPolygon.setLineStyleColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
        hSSFPolygon.setLineWidth(0);
        hSSFPolygon.setNoFill(true);
    }

    private int[] addToAll(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] + n;
        }
        return nArray2;
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (logger.check(5)) {
            logger.log(5, "drawPolyline not supported");
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (logger.check(5)) {
            logger.log(5, "drawRect not supported");
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (logger.check(5)) {
            logger.log(5, "drawRoundRect not supported");
        }
    }

    public void drawString(String string, int n, int n2) {
        if (string == null || string.equals("")) {
            return;
        }
        Font font = this.font;
        font = this.font.getName().equals("SansSerif") ? new Font("Arial", this.font.getStyle(), (int)((float)this.font.getSize() / this.verticalPixelsPerPoint)) : new Font(this.font.getName(), this.font.getStyle(), (int)((float)this.font.getSize() / this.verticalPixelsPerPoint));
        FontDetails fontDetails = StaticFontMetrics.getFontDetails(font);
        int n3 = fontDetails.getStringWidth(string) * 8 + 12;
        int n4 = (int)((float)this.font.getSize() / this.verticalPixelsPerPoint + 6.0f) * 2;
        n2 = (int)((float)n2 - ((float)this.font.getSize() / this.verticalPixelsPerPoint + 2.0f * this.verticalPixelsPerPoint));
        HSSFTextbox hSSFTextbox = this.escherGroup.createTextbox(new HSSFChildAnchor(n, n2, n + n3, n2 + n4));
        hSSFTextbox.setNoFill(true);
        hSSFTextbox.setLineStyle(-1);
        HSSFRichTextString hSSFRichTextString = new HSSFRichTextString(string);
        HSSFFont hSSFFont = this.matchFont(font);
        hSSFRichTextString.applyFont(hSSFFont);
        hSSFTextbox.setString(hSSFRichTextString);
    }

    private HSSFFont matchFont(Font font) {
        HSSFColor hSSFColor = this.workbook.getCustomPalette().findColor((byte)this.foreground.getRed(), (byte)this.foreground.getGreen(), (byte)this.foreground.getBlue());
        if (hSSFColor == null) {
            hSSFColor = this.workbook.getCustomPalette().findSimilarColor((byte)this.foreground.getRed(), (byte)this.foreground.getGreen(), (byte)this.foreground.getBlue());
        }
        boolean bl = (font.getStyle() & 1) != 0;
        boolean bl2 = (font.getStyle() & 2) != 0;
        HSSFFont hSSFFont = this.workbook.findFont(bl ? (short)700 : 0, hSSFColor.getIndex(), (short)(font.getSize() * 20), font.getName(), bl2, false, (short)0, (byte)0);
        if (hSSFFont == null) {
            hSSFFont = this.workbook.createFont();
            hSSFFont.setBoldweight(bl ? (short)700 : 0);
            hSSFFont.setColor(hSSFColor.getIndex());
            hSSFFont.setFontHeight((short)(font.getSize() * 20));
            hSSFFont.setFontName(font.getName());
            hSSFFont.setItalic(bl2);
            hSSFFont.setStrikeout(false);
            hSSFFont.setTypeOffset((short)0);
            hSSFFont.setUnderline((byte)0);
        }
        return hSSFFont;
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (logger.check(5)) {
            logger.log(5, "drawString not supported");
        }
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (logger.check(5)) {
            logger.log(5, "fillArc not supported");
        }
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        HSSFSimpleShape hSSFSimpleShape = this.escherGroup.createShape(new HSSFChildAnchor(n, n2, n + n3, n2 + n4));
        hSSFSimpleShape.setShapeType(3);
        hSSFSimpleShape.setLineStyle(-1);
        hSSFSimpleShape.setFillColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
        hSSFSimpleShape.setLineStyleColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int n2 = this.findBiggest(nArray);
        int n3 = this.findBiggest(nArray2);
        int n4 = this.findSmallest(nArray);
        int n5 = this.findSmallest(nArray2);
        HSSFPolygon hSSFPolygon = this.escherGroup.createPolygon(new HSSFChildAnchor(n4, n5, n2, n3));
        hSSFPolygon.setPolygonDrawArea(n2 - n4, n3 - n5);
        hSSFPolygon.setPoints(this.addToAll(nArray, -n4), this.addToAll(nArray2, -n5));
        hSSFPolygon.setLineStyleColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
        hSSFPolygon.setFillColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
    }

    private int findBiggest(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private int findSmallest(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        HSSFSimpleShape hSSFSimpleShape = this.escherGroup.createShape(new HSSFChildAnchor(n, n2, n + n3, n2 + n4));
        hSSFSimpleShape.setShapeType(2);
        hSSFSimpleShape.setLineStyle(-1);
        hSSFSimpleShape.setFillColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
        hSSFSimpleShape.setLineStyleColor(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (logger.check(5)) {
            logger.log(5, "fillRoundRect not supported");
        }
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    public Color getColor() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
    }

    public void setColor(Color color) {
        this.foreground = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPaintMode() {
        if (logger.check(5)) {
            logger.log(5, "setPaintMode not supported");
        }
    }

    public void setXORMode(Color color) {
        if (logger.check(5)) {
            logger.log(5, "setXORMode not supported");
        }
    }

    public void translate(int n, int n2) {
        if (logger.check(5)) {
            logger.log(5, "translate not supported");
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    HSSFShapeGroup getEscherGraphics() {
        return this.escherGroup;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

