/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public abstract class XYNumericFunction
implements Function {
    protected static final int X = 0;
    protected static final int Y = 1;

    public final Eval evaluate(Eval[] evalArray, int n, short s) {
        double[][] dArray;
        if (evalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            dArray = XYNumericFunction.getValues(evalArray[0], evalArray[1]);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (dArray == null || dArray[0] == null || dArray[1] == null || dArray[0].length == 0 || dArray[1].length == 0 || dArray[0].length != dArray[1].length) {
            return ErrorEval.VALUE_INVALID;
        }
        double d = this.evaluate(dArray[0], dArray[1]);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    protected abstract double evaluate(double[] var1, double[] var2);

    private static double[][] getNumberArray(Eval[] evalArray, Eval[] evalArray2) throws EvaluationException {
        Object object;
        int n;
        int n2 = evalArray.length;
        if (n2 != evalArray2.length) {
            throw new EvaluationException(ErrorEval.NA);
        }
        for (n = 0; n < evalArray.length; ++n) {
            object = evalArray[n];
            if (!(object instanceof ErrorEval)) continue;
            throw new EvaluationException((ErrorEval)object);
        }
        for (n = 0; n < evalArray2.length; ++n) {
            object = evalArray2[n];
            if (!(object instanceof ErrorEval)) continue;
            throw new EvaluationException((ErrorEval)object);
        }
        double[] dArray = new double[n2];
        object = new double[n2];
        int n3 = 0;
        int n4 = n2;
        for (int i = 0; i < n4; ++i) {
            Eval eval = evalArray[i];
            Eval eval2 = evalArray2[i];
            if (!XYNumericFunction.isNumberEval(eval) || !XYNumericFunction.isNumberEval(eval2)) continue;
            dArray[n3] = XYNumericFunction.getDoubleValue(eval);
            object[n3] = XYNumericFunction.getDoubleValue(eval2);
            if (Double.isNaN(dArray[n3]) || Double.isNaN(dArray[n3])) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            ++n3;
        }
        return new double[][]{XYNumericFunction.trimToSize(dArray, n3), XYNumericFunction.trimToSize((double[])object, n3)};
    }

    private static double[][] getValues(Eval eval, Eval eval2) throws EvaluationException {
        Eval[] evalArray;
        Eval[] evalArray2;
        AreaEval areaEval;
        if (eval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)eval);
        }
        if (eval2 instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)eval2);
        }
        if (eval instanceof AreaEval) {
            areaEval = (AreaEval)eval;
            evalArray2 = areaEval.getValues();
        } else {
            evalArray2 = new Eval[]{eval};
        }
        if (eval2 instanceof AreaEval) {
            areaEval = (AreaEval)eval2;
            evalArray = areaEval.getValues();
        } else {
            evalArray = new Eval[]{eval2};
        }
        return XYNumericFunction.getNumberArray(evalArray2, evalArray);
    }

    private static double[] trimToSize(double[] dArray, int n) {
        double[] dArray2 = dArray;
        if (dArray.length > n) {
            dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, n);
        }
        return dArray2;
    }

    private static boolean isNumberEval(Eval eval) {
        boolean bl = false;
        if (eval instanceof NumberEval) {
            bl = true;
        } else if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            ValueEval valueEval = refEval.getInnerValueEval();
            bl = valueEval instanceof NumberEval;
        }
        return bl;
    }

    private static double getDoubleValue(Eval eval) {
        double d = 0.0;
        if (eval instanceof NumberEval) {
            NumberEval numberEval = (NumberEval)eval;
            d = numberEval.getNumberValue();
        } else if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            ValueEval valueEval = refEval.getInnerValueEval();
            d = valueEval instanceof NumberEval ? ((NumberEval)valueEval).getNumberValue() : Double.NaN;
        } else if (eval instanceof ErrorEval) {
            d = Double.NaN;
        }
        return d;
    }

    protected static final class DoubleArrayPair {
        private final double[] _xArray;
        private final double[] _yArray;

        public DoubleArrayPair(double[] dArray, double[] dArray2) {
            this._xArray = dArray;
            this._yArray = dArray2;
        }

        public double[] getXArray() {
            return this._xArray;
        }

        public double[] getYArray() {
            return this._yArray;
        }
    }
}

