/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Vlookup
implements Function {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        Eval eval = null;
        switch (evalArray.length) {
            case 4: {
                eval = evalArray[3];
            }
            case 3: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ValueEval valueEval = OperandResolver.getSingleValue(evalArray[0], n, s);
            AreaEval areaEval = LookupUtils.resolveTableArrayArg(evalArray[1]);
            boolean bl = LookupUtils.resolveRangeLookupArg(eval, n, s);
            int n2 = LookupUtils.lookupIndexOfValue(valueEval, new ColumnVector(areaEval, 0), bl);
            ValueEval valueEval2 = OperandResolver.getSingleValue(evalArray[2], n, s);
            int n3 = LookupUtils.resolveRowOrColIndexArg(valueEval2);
            LookupUtils.ValueVector valueVector = this.createResultColumnVector(areaEval, n3);
            return valueVector.getItem(n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private LookupUtils.ValueVector createResultColumnVector(AreaEval areaEval, int n) throws EvaluationException {
        if (n < 0) {
            throw EvaluationException.invalidValue();
        }
        int n2 = areaEval.getLastColumn() - areaEval.getFirstColumn() + 1;
        if (n >= n2) {
            throw EvaluationException.invalidRef();
        }
        return new ColumnVector(areaEval, n);
    }

    private static final class ColumnVector
    implements LookupUtils.ValueVector {
        private final AreaEval _tableArray;
        private final int _size;
        private final int _columnAbsoluteIndex;
        private final int _firstRowAbsoluteIndex;

        public ColumnVector(AreaEval areaEval, int n) {
            this._columnAbsoluteIndex = areaEval.getFirstColumn() + n;
            if (!areaEval.containsColumn((short)this._columnAbsoluteIndex)) {
                int n2 = areaEval.getLastColumn() - areaEval.getFirstColumn();
                throw new IllegalArgumentException("Specified column index (" + n + ") is outside the allowed range (0.." + n2 + ")");
            }
            this._tableArray = areaEval;
            this._size = areaEval.getLastRow() - areaEval.getFirstRow() + 1;
            if (this._size < 1) {
                throw new RuntimeException("bad table array size zero");
            }
            this._firstRowAbsoluteIndex = areaEval.getFirstRow();
        }

        public ValueEval getItem(int n) {
            if (n > this._size) {
                throw new ArrayIndexOutOfBoundsException("Specified index (" + n + ") is outside the allowed range (0.." + (this._size - 1) + ")");
            }
            return this._tableArray.getValueAt(this._firstRowAbsoluteIndex + n, (short)this._columnAbsoluteIndex);
        }

        public int getSize() {
            return this._size;
        }
    }
}

