/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public final class Sumproduct
implements Function {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        int n2 = evalArray.length;
        if (n2 < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        Eval eval = evalArray[0];
        try {
            if (eval instanceof NumericValueEval) {
                return this.evaluateSingleProduct(evalArray);
            }
            if (eval instanceof RefEval) {
                return this.evaluateSingleProduct(evalArray);
            }
            if (eval instanceof AreaEval) {
                AreaEval areaEval = (AreaEval)eval;
                if (areaEval.isRow() && areaEval.isColumn()) {
                    return this.evaluateSingleProduct(evalArray);
                }
                return this.evaluateAreaSumProduct(evalArray);
            }
        }
        catch (EvalEx evalEx) {
            return evalEx.getError();
        }
        throw new RuntimeException("Invalid arg type for SUMPRODUCT: (" + eval.getClass().getName() + ")");
    }

    private Eval evaluateSingleProduct(Eval[] evalArray) throws EvalEx {
        int n = evalArray.length;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.getScalarValue(evalArray[i]);
            d *= d2;
        }
        return new NumberEval(d);
    }

    private double getScalarValue(Eval eval) throws EvalEx {
        Eval eval2;
        ValueEval valueEval;
        if (eval instanceof RefEval) {
            valueEval = (RefEval)eval;
            eval2 = valueEval.getInnerValueEval();
        } else {
            eval2 = eval;
        }
        if (eval2 == null) {
            throw new RuntimeException("parameter may not be null");
        }
        if (eval2 instanceof AreaEval) {
            valueEval = (AreaEval)eval2;
            if (!valueEval.isColumn() || !valueEval.isRow()) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            eval2 = valueEval.getValues()[0];
        }
        if (!(eval2 instanceof ValueEval)) {
            throw new RuntimeException("Unexpected value eval class (" + eval2.getClass().getName() + ")");
        }
        return Sumproduct.getProductTerm((ValueEval)eval2, true);
    }

    private Eval evaluateAreaSumProduct(Eval[] evalArray) throws EvalEx {
        int n = evalArray.length;
        AreaEval[] areaEvalArray = new AreaEval[n];
        try {
            System.arraycopy(evalArray, 0, areaEvalArray, 0, n);
        }
        catch (ArrayStoreException arrayStoreException) {
            return ErrorEval.VALUE_INVALID;
        }
        AreaEval areaEval = areaEvalArray[0];
        int n2 = areaEval.getLastRow() - areaEval.getFirstRow() + 1;
        int n3 = areaEval.getLastColumn() - areaEval.getFirstColumn() + 1;
        double[][][] dArrayArray = new double[n][][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = Sumproduct.evaluateArea(areaEvalArray[i], n2, n3);
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d2 = 1.0;
                for (int k = 0; k < n; ++k) {
                    d2 *= dArrayArray[k][i][j];
                }
                d += d2;
            }
        }
        return new NumberEval(d);
    }

    private static double[][] evaluateArea(AreaEval areaEval, int n, int n2) throws EvalEx {
        int n3 = areaEval.getFirstRow();
        int n4 = areaEval.getFirstColumn();
        if (areaEval.getLastRow() - n3 + 1 != n) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        if (areaEval.getLastColumn() - n4 + 1 != n2) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        ValueEval[] valueEvalArray = areaEval.getValues();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                ValueEval valueEval = valueEvalArray[i * n2 + j];
                dArray[i][j] = Sumproduct.getProductTerm(valueEval, false);
            }
        }
        return dArray;
    }

    private static double getProductTerm(ValueEval valueEval, boolean bl) throws EvalEx {
        if (valueEval instanceof BlankEval || valueEval == null) {
            if (bl) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvalEx((ErrorEval)valueEval);
        }
        if (valueEval instanceof StringEval) {
            if (bl) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            return numericValueEval.getNumberValue();
        }
        throw new RuntimeException("Unexpected value eval class (" + valueEval.getClass().getName() + ")");
    }

    private static final class EvalEx
    extends Exception {
        private final ErrorEval _error;

        public EvalEx(ErrorEval errorEval) {
            this._error = errorEval;
        }

        public ErrorEval getError() {
            return this._error;
        }
    }
}

