/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import java.util.Arrays;

public final class StatsLib {
    private StatsLib() {
    }

    public static double avedev(double[] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d3 += dArray[n];
        }
        d2 = d3 / (double)dArray.length;
        d3 = 0.0;
        n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d3 += Math.abs(dArray[n] - d2);
        }
        d = d3 / (double)dArray.length;
        return d;
    }

    public static double stdev(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > 1) {
            d = Math.sqrt(StatsLib.devsq(dArray) / (double)(dArray.length - 1));
        }
        return d;
    }

    public static double mode(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > 1) {
            int n;
            int n2;
            int[] nArray = new int[dArray.length];
            Arrays.fill(nArray, 1);
            int n3 = dArray.length;
            for (int i = 0; i < n3; ++i) {
                n2 = dArray.length;
                for (n = i + 1; n < n2; ++n) {
                    if (dArray[i] != dArray[n]) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                }
            }
            double d2 = 0.0;
            n = 0;
            int n5 = nArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n2] <= n) continue;
                d2 = dArray[n2];
                n = nArray[n2];
            }
            d = n > 1 ? d2 : Double.NaN;
        }
        return d;
    }

    public static double median(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length >= 1) {
            int n = dArray.length;
            Arrays.sort(dArray);
            d = n % 2 == 0 ? (dArray[n / 2] + dArray[n / 2 - 1]) / 2.0 : dArray[n / 2];
        }
        return d;
    }

    public static double devsq(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length >= 1) {
            int n;
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = dArray.length;
            for (n = 0; n < n2; ++n) {
                d3 += dArray[n];
            }
            d2 = d3 / (double)n2;
            d3 = 0.0;
            for (n = 0; n < n2; ++n) {
                d3 += (dArray[n] - d2) * (dArray[n] - d2);
            }
            d = n2 == 1 ? 0.0 : d3;
        }
        return d;
    }

    public static double kthLargest(double[] dArray, int n) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > --n && n >= 0) {
            Arrays.sort(dArray);
            d = dArray[dArray.length - n - 1];
        }
        return d;
    }

    public static double kthSmallest(double[] dArray, int n) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > --n && n >= 0) {
            Arrays.sort(dArray);
            d = dArray[n];
        }
        return d;
    }
}

