/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.TextFunction;

public class Right
extends TextFunction {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        ValueEval valueEval = ErrorEval.VALUE_INVALID;
        int n2 = 1;
        switch (evalArray.length) {
            default: {
                break;
            }
            case 2: {
                Eval eval = evalArray[1];
                n2 = this.evaluateAsInteger(eval);
                if (n2 < 0) break;
            }
            case 1: {
                StringValueEval stringValueEval;
                ValueEval valueEval2 = this.singleOperandEvaluate(evalArray[0], n, s);
                String string = null;
                if (valueEval2 instanceof StringEval) {
                    stringValueEval = (StringEval)valueEval2;
                    string = ((StringEval)stringValueEval).getStringValue();
                } else if (valueEval2 instanceof BoolEval) {
                    stringValueEval = (BoolEval)valueEval2;
                    string = ((BoolEval)stringValueEval).getBooleanValue() ? "TRUE" : "FALSE";
                } else if (valueEval2 instanceof NumberEval) {
                    stringValueEval = (NumberEval)valueEval2;
                    string = ((NumberEval)stringValueEval).getStringValue();
                }
                if (null == string) break;
                int n3 = string.length();
                string = string.substring(Math.max(0, n3 - n2));
                valueEval = new StringEval(string);
            }
        }
        return valueEval;
    }

    protected int evaluateAsInteger(Eval eval) {
        int n = -1;
        if (eval instanceof NumberEval) {
            NumberEval numberEval = (NumberEval)eval;
            double d = numberEval.getNumberValue();
            n = (int)d;
        } else if (eval instanceof StringEval) {
            StringEval stringEval = (StringEval)eval;
            String string = stringEval.getStringValue();
            try {
                double d = Double.parseDouble(string);
                n = (int)d;
            }
            catch (Exception exception) {}
        } else if (eval instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)eval;
            n = boolEval.getBooleanValue() ? 1 : 0;
        } else if (eval instanceof RefEval) {
            n = this.evaluateAsInteger(this.xlateRefEval((RefEval)eval));
        }
        return n;
    }

    protected Eval xlateRefEval(RefEval refEval) {
        Eval eval = refEval.getInnerValueEval();
        if (eval instanceof RefEval) {
            eval = this.xlateRefEval((RefEval)eval);
        }
        return eval;
    }
}

