/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;

public class Radians
extends NumericFunction {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        double d = 0.0;
        ErrorEval errorEval = null;
        switch (evalArray.length) {
            default: {
                errorEval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval valueEval = this.singleOperandEvaluate(evalArray[0], n, s);
                if (valueEval instanceof NumericValueEval) {
                    NumericValueEval numericValueEval = (NumericValueEval)valueEval;
                    d = numericValueEval.getNumberValue();
                    break;
                }
                if (valueEval instanceof BlankEval) break;
                errorEval = ErrorEval.NUM_ERROR;
            }
        }
        if (errorEval == null) {
            errorEval = Double.isNaN(d = Math.toRadians(d)) || Double.isInfinite(d) ? ErrorEval.VALUE_INVALID : new NumberEval(d);
        }
        return errorEval;
    }
}

