/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FinanceFunction;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FinanceLib;

public final class Pmt
extends FinanceFunction {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        if (evalArray.length < 3 || evalArray.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double d = this.evalArg(evalArray[0], n, s);
            double d2 = this.evalArg(evalArray[1], n, s);
            double d3 = this.evalArg(evalArray[2], n, s);
            double d4 = 0.0;
            boolean bl = false;
            switch (evalArray.length) {
                case 5: {
                    ValueEval valueEval = this.singleOperandNumericAsBoolean(evalArray[4], n, s);
                    if (valueEval instanceof ErrorEval) {
                        return valueEval;
                    }
                    bl = ((BoolEval)valueEval).getBooleanValue();
                }
                case 4: {
                    d4 = this.evalArg(evalArray[3], n, s);
                }
            }
            double d5 = FinanceLib.pmt(d, d2, d3, d4, bl);
            if (Double.isNaN(d5)) {
                return ErrorEval.VALUE_INVALID;
            }
            if (Double.isInfinite(d5)) {
                return ErrorEval.NUM_ERROR;
            }
            return new NumberEval(d5);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private double evalArg(Eval eval, int n, short s) throws EvaluationException {
        ValueEval valueEval = this.singleOperandEvaluate(eval, n, s);
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval instanceof NumericValueEval) {
            return ((NumericValueEval)valueEval).getNumberValue();
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

