/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Area3DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Ref3DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Countif;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class Offset
implements FreeRefFunction {
    private static final int LAST_VALID_ROW_INDEX = 65535;
    private static final int LAST_VALID_COLUMN_INDEX = 255;

    public ValueEval evaluate(Eval[] evalArray, int n, short s, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet) {
        if (evalArray.length < 3 || evalArray.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            BaseRef baseRef = Offset.evaluateBaseRef(evalArray[0]);
            int n2 = Offset.evaluateIntArg(evalArray[1], n, s);
            int n3 = Offset.evaluateIntArg(evalArray[2], n, s);
            int n4 = baseRef.getHeight();
            int n5 = baseRef.getWidth();
            switch (evalArray.length) {
                case 5: {
                    n5 = Offset.evaluateIntArg(evalArray[4], n, s);
                }
                case 4: {
                    n4 = Offset.evaluateIntArg(evalArray[3], n, s);
                }
            }
            if (n4 == 0 || n5 == 0) {
                return ErrorEval.REF_INVALID;
            }
            LinearOffsetRange linearOffsetRange = new LinearOffsetRange(n2, n4);
            LinearOffsetRange linearOffsetRange2 = new LinearOffsetRange(n3, n5);
            return Offset.createOffset(baseRef, linearOffsetRange, linearOffsetRange2, hSSFWorkbook, hSSFSheet);
        }
        catch (EvalEx evalEx) {
            return evalEx.getError();
        }
    }

    private static AreaEval createOffset(BaseRef baseRef, LinearOffsetRange linearOffsetRange, LinearOffsetRange linearOffsetRange2, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet) throws EvalEx {
        LinearOffsetRange linearOffsetRange3 = linearOffsetRange.normaliseAndTranslate(baseRef.getFirstRowIndex());
        LinearOffsetRange linearOffsetRange4 = linearOffsetRange2.normaliseAndTranslate(baseRef.getFirstColumnIndex());
        if (linearOffsetRange3.isOutOfBounds(0, 65535)) {
            throw new EvalEx(ErrorEval.REF_INVALID);
        }
        if (linearOffsetRange4.isOutOfBounds(0, 255)) {
            throw new EvalEx(ErrorEval.REF_INVALID);
        }
        if (baseRef.isIs3d()) {
            Area3DPtg area3DPtg = new Area3DPtg(linearOffsetRange3.getFirstIndex(), linearOffsetRange3.getLastIndex(), linearOffsetRange4.getFirstIndex(), linearOffsetRange4.getLastIndex(), false, false, false, false, baseRef.getExternalSheetIndex());
            return HSSFFormulaEvaluator.evaluateArea3dPtg(hSSFWorkbook, area3DPtg);
        }
        AreaPtg areaPtg = new AreaPtg(linearOffsetRange3.getFirstIndex(), linearOffsetRange3.getLastIndex(), linearOffsetRange4.getFirstIndex(), linearOffsetRange4.getLastIndex(), false, false, false, false);
        return HSSFFormulaEvaluator.evaluateAreaPtg(hSSFSheet, hSSFWorkbook, areaPtg);
    }

    private static BaseRef evaluateBaseRef(Eval eval) throws EvalEx {
        if (eval instanceof RefEval) {
            return new BaseRef((RefEval)eval);
        }
        if (eval instanceof AreaEval) {
            return new BaseRef((AreaEval)eval);
        }
        if (eval instanceof ErrorEval) {
            throw new EvalEx((ErrorEval)eval);
        }
        throw new EvalEx(ErrorEval.VALUE_INVALID);
    }

    private static int evaluateIntArg(Eval eval, int n, short s) throws EvalEx {
        double d = Offset.evaluateDoubleArg(eval, n, s);
        return Offset.convertDoubleToInt(d);
    }

    static int convertDoubleToInt(double d) {
        return (int)Math.floor(d);
    }

    private static double evaluateDoubleArg(Eval eval, int n, short s) throws EvalEx {
        ValueEval valueEval = Offset.evaluateSingleValue(eval, n, s);
        if (valueEval instanceof NumericValueEval) {
            return ((NumericValueEval)valueEval).getNumberValue();
        }
        if (valueEval instanceof StringEval) {
            StringEval stringEval = (StringEval)valueEval;
            Double d = Offset.parseDouble(stringEval.getStringValue());
            if (d == null) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return d;
        }
        if (valueEval instanceof BoolEval) {
            if (((BoolEval)valueEval).getBooleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        throw new RuntimeException("Unexpected eval type (" + valueEval.getClass().getName() + ")");
    }

    private static Double parseDouble(String string) {
        return Countif.parseDouble(string);
    }

    private static ValueEval evaluateSingleValue(Eval eval, int n, short s) throws EvalEx {
        if (eval instanceof RefEval) {
            return ((RefEval)eval).getInnerValueEval();
        }
        if (eval instanceof AreaEval) {
            return Offset.chooseSingleElementFromArea((AreaEval)eval, n, s);
        }
        if (eval instanceof ValueEval) {
            return (ValueEval)eval;
        }
        throw new RuntimeException("Unexpected eval type (" + eval.getClass().getName() + ")");
    }

    private static ValueEval chooseSingleElementFromArea(AreaEval areaEval, int n, short s) throws EvalEx {
        if (areaEval.isColumn()) {
            if (areaEval.isRow()) {
                return areaEval.getValues()[0];
            }
            if (!areaEval.containsRow(n)) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return areaEval.getValueAt(n, areaEval.getFirstColumn());
        }
        if (!areaEval.isRow()) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        if (!areaEval.containsColumn(s)) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        return areaEval.getValueAt(areaEval.getFirstRow(), s);
    }

    private static final class BaseRef {
        private static final int INVALID_SHEET_INDEX = -1;
        private final int _firstRowIndex;
        private final int _firstColumnIndex;
        private final int _width;
        private final int _height;
        private final int _externalSheetIndex;

        public BaseRef(RefEval refEval) {
            this._firstRowIndex = refEval.getRow();
            this._firstColumnIndex = refEval.getColumn();
            this._height = 1;
            this._width = 1;
            if (refEval instanceof Ref3DEval) {
                Ref3DEval ref3DEval = (Ref3DEval)refEval;
                this._externalSheetIndex = ref3DEval.getExternSheetIndex();
            } else {
                this._externalSheetIndex = -1;
            }
        }

        public BaseRef(AreaEval areaEval) {
            this._firstRowIndex = areaEval.getFirstRow();
            this._firstColumnIndex = areaEval.getFirstColumn();
            this._height = areaEval.getLastRow() - areaEval.getFirstRow() + 1;
            this._width = areaEval.getLastColumn() - areaEval.getFirstColumn() + 1;
            if (areaEval instanceof Area3DEval) {
                Area3DEval area3DEval = (Area3DEval)areaEval;
                this._externalSheetIndex = area3DEval.getExternSheetIndex();
            } else {
                this._externalSheetIndex = -1;
            }
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }

        public int getFirstRowIndex() {
            return this._firstRowIndex;
        }

        public int getFirstColumnIndex() {
            return this._firstColumnIndex;
        }

        public boolean isIs3d() {
            return this._externalSheetIndex > 0;
        }

        public short getExternalSheetIndex() {
            if (this._externalSheetIndex < 0) {
                throw new IllegalStateException("external sheet index only available for 3d refs");
            }
            return (short)this._externalSheetIndex;
        }
    }

    static final class LinearOffsetRange {
        private final int _offset;
        private final int _length;

        public LinearOffsetRange(int n, int n2) {
            if (n2 == 0) {
                throw new RuntimeException("length may not be zero");
            }
            this._offset = n;
            this._length = n2;
        }

        public short getFirstIndex() {
            return (short)this._offset;
        }

        public short getLastIndex() {
            return (short)(this._offset + this._length - 1);
        }

        public LinearOffsetRange normaliseAndTranslate(int n) {
            if (this._length > 0) {
                if (n == 0) {
                    return this;
                }
                return new LinearOffsetRange(n + this._offset, this._length);
            }
            return new LinearOffsetRange(n + this._offset + this._length + 1, -this._length);
        }

        public boolean isOutOfBounds(int n, int n2) {
            if (this._offset < n) {
                return true;
            }
            return this.getLastIndex() > n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this._offset).append("...").append(this.getLastIndex());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static final class EvalEx
    extends Exception {
        private final ErrorEval _error;

        public EvalEx(ErrorEval errorEval) {
            this._error = errorEval;
        }

        public ErrorEval getError() {
            return this._error;
        }
    }
}

