/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public abstract class NumericFunction
implements Function {
    protected static final double E = Math.E;
    protected static final double PI = Math.PI;
    private static final ValueEvalToNumericXlator DEFAULT_NUM_XLATOR = new ValueEvalToNumericXlator(27);
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected ValueEvalToNumericXlator getXlator() {
        return DEFAULT_NUM_XLATOR;
    }

    protected ValueEval singleOperandEvaluate(Eval eval, int n, short s) {
        ValueEval valueEval;
        if (eval instanceof AreaEval) {
            AreaEval areaEval = (AreaEval)eval;
            if (areaEval.contains(n, s)) {
                valueEval = ErrorEval.CIRCULAR_REF_ERROR;
            } else if (areaEval.isRow()) {
                if (areaEval.containsColumn(s)) {
                    ValueEval valueEval2 = areaEval.getValueAt(areaEval.getFirstRow(), s);
                    valueEval2 = this.getXlator().attemptXlateToNumeric(valueEval2);
                    valueEval = this.getXlator().attemptXlateToNumeric(valueEval2);
                } else {
                    valueEval = ErrorEval.VALUE_INVALID;
                }
            } else if (areaEval.isColumn()) {
                if (areaEval.containsRow(n)) {
                    ValueEval valueEval3 = areaEval.getValueAt(n, areaEval.getFirstColumn());
                    valueEval = this.getXlator().attemptXlateToNumeric(valueEval3);
                } else {
                    valueEval = ErrorEval.VALUE_INVALID;
                }
            } else {
                valueEval = ErrorEval.VALUE_INVALID;
            }
        } else {
            valueEval = this.getXlator().attemptXlateToNumeric((ValueEval)eval);
        }
        return valueEval;
    }
}

