/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Ref2DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;

public abstract class MultiOperandNumericFunction
extends NumericFunction {
    static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected abstract ValueEvalToNumericXlator getXlator();

    protected int getMaxNumOperands() {
        return 30;
    }

    protected double[] getNumberArray(Eval[] evalArray, int n, short s) {
        if (evalArray.length > this.getMaxNumOperands()) {
            return null;
        }
        DoubleList doubleList = new DoubleList();
        int n2 = evalArray.length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray = this.getNumberArray(evalArray[i], n, s);
            if (dArray == null) {
                return null;
            }
            doubleList.add(dArray);
        }
        return doubleList.toArray();
    }

    protected double[] getNumberArray(Eval eval, int n, short s) {
        if (eval instanceof AreaEval) {
            AreaEval areaEval = (AreaEval)eval;
            ValueEval[] valueEvalArray = areaEval.getValues();
            DoubleList doubleList = new DoubleList();
            int n2 = valueEvalArray.length;
            for (int i = 0; i < n2; ++i) {
                Ref2DEval ref2DEval = new Ref2DEval(null, valueEvalArray[i]);
                ValueEval valueEval = this.singleOperandEvaluate(ref2DEval, n, s);
                if (valueEval instanceof NumericValueEval) {
                    NumericValueEval numericValueEval = (NumericValueEval)valueEval;
                    doubleList.add(numericValueEval.getNumberValue());
                    continue;
                }
                if (valueEval instanceof BlankEval) continue;
                return null;
            }
            return doubleList.toArray();
        }
        ValueEval valueEval = this.singleOperandEvaluate(eval, n, s);
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            return new double[]{numericValueEval.getNumberValue()};
        }
        if (valueEval instanceof BlankEval) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return null;
    }

    protected static final boolean areSubArraysConsistent(double[][] dArray) {
        if (dArray == null || dArray.length < 1) {
            return true;
        }
        if (dArray[0] == null) {
            return false;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 1; i < n; ++i) {
            double[] dArray2 = dArray[i];
            if (dArray2 == null) {
                return false;
            }
            if (n2 == dArray2.length) continue;
            return false;
        }
        return true;
    }

    private static class DoubleList {
        private double[] _array = new double[8];
        private int _count = 0;

        public double[] toArray() {
            if (this._count < 1) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] dArray = new double[this._count];
            System.arraycopy(this._array, 0, dArray, 0, this._count);
            return dArray;
        }

        public void add(double[] dArray) {
            int n = dArray.length;
            this.ensureCapacity(this._count + n);
            System.arraycopy(dArray, 0, this._array, this._count, n);
            this._count += n;
        }

        private void ensureCapacity(int n) {
            if (n > this._array.length) {
                int n2 = n * 3 / 2;
                double[] dArray = new double[n2];
                System.arraycopy(this._array, 0, dArray, 0, this._count);
                this._array = dArray;
            }
        }

        public void add(double d) {
            this.ensureCapacity(this._count + 1);
            this._array[this._count] = d;
            ++this._count;
        }
    }
}

