/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Match
implements Function {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        double d = 1.0;
        switch (evalArray.length) {
            case 3: {
                try {
                    d = Match.evaluateMatchTypeArg(evalArray[2], n, s);
                    break;
                }
                catch (EvaluationException evaluationException) {
                    return ErrorEval.REF_INVALID;
                }
            }
            case 2: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        boolean bl = d == 0.0;
        boolean bl2 = d > 0.0;
        try {
            ValueEval valueEval = OperandResolver.getSingleValue(evalArray[0], n, s);
            ValueEval[] valueEvalArray = Match.evaluateLookupRange(evalArray[1]);
            int n2 = Match.findIndexOfValue(valueEval, valueEvalArray, bl, bl2);
            return new NumberEval(n2 + 1);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static ValueEval[] evaluateLookupRange(Eval eval) throws EvaluationException {
        if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            return new ValueEval[]{refEval.getInnerValueEval()};
        }
        if (eval instanceof AreaEval) {
            AreaEval areaEval = (AreaEval)eval;
            if (!areaEval.isColumn() && !areaEval.isRow()) {
                throw new EvaluationException(ErrorEval.NA);
            }
            return areaEval.getValues();
        }
        if (eval instanceof NumericValueEval) {
            throw new EvaluationException(ErrorEval.NA);
        }
        if (eval instanceof StringEval) {
            StringEval stringEval = (StringEval)eval;
            Double d = OperandResolver.parseDouble(stringEval.getStringValue());
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        throw new RuntimeException("Unexpected eval type (" + eval.getClass().getName() + ")");
    }

    private static double evaluateMatchTypeArg(Eval eval, int n, short s) throws EvaluationException {
        ValueEval valueEval = OperandResolver.getSingleValue(eval, n, s);
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            return numericValueEval.getNumberValue();
        }
        if (valueEval instanceof StringEval) {
            StringEval stringEval = (StringEval)valueEval;
            Double d = OperandResolver.parseDouble(stringEval.getStringValue());
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return d;
        }
        throw new RuntimeException("Unexpected match_type type (" + valueEval.getClass().getName() + ")");
    }

    private static int findIndexOfValue(ValueEval valueEval, ValueEval[] valueEvalArray, boolean bl, boolean bl2) throws EvaluationException {
        LookupUtils.LookupValueComparer lookupValueComparer = Match.createLookupComparer(valueEval, bl);
        if (bl) {
            for (int i = 0; i < valueEvalArray.length; ++i) {
                if (!lookupValueComparer.compareTo(valueEvalArray[i]).isEqual()) continue;
                return i;
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        if (bl2) {
            for (int i = valueEvalArray.length - 1; i >= 0; --i) {
                LookupUtils.CompareResult compareResult = lookupValueComparer.compareTo(valueEvalArray[i]);
                if (compareResult.isTypeMismatch() || compareResult.isLessThan()) continue;
                return i;
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        for (int i = 0; i < valueEvalArray.length; ++i) {
            LookupUtils.CompareResult compareResult = lookupValueComparer.compareTo(valueEvalArray[i]);
            if (compareResult.isEqual()) {
                return i;
            }
            if (!compareResult.isGreaterThan()) continue;
            if (i < 1) {
                throw new EvaluationException(ErrorEval.NA);
            }
            return i - 1;
        }
        throw new EvaluationException(ErrorEval.NA);
    }

    private static LookupUtils.LookupValueComparer createLookupComparer(ValueEval valueEval, boolean bl) throws EvaluationException {
        String string;
        if (bl && valueEval instanceof StringEval && Match.isLookupValueWild(string = ((StringEval)valueEval).getStringValue())) {
            throw new RuntimeException("Wildcard lookup values '" + string + "' not supported yet");
        }
        return LookupUtils.createLookupComparer(valueEval);
    }

    private static boolean isLookupValueWild(String string) {
        return string.indexOf(63) >= 0 || string.indexOf(42) >= 0;
    }
}

