/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Area2DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Countif;

final class LookupUtils {
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval;

    LookupUtils() {
    }

    public static int resolveRowOrColIndexArg(ValueEval valueEval) throws EvaluationException {
        StringEval stringEval;
        String string;
        Double d;
        if (valueEval == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (valueEval instanceof BlankEval) {
            throw EvaluationException.invalidValue();
        }
        if (valueEval instanceof StringEval && (d = OperandResolver.parseDouble(string = (stringEval = (StringEval)valueEval).getStringValue())) == null) {
            throw EvaluationException.invalidRef();
        }
        return OperandResolver.coerceValueToInt(valueEval) - 1;
    }

    public static AreaEval resolveTableArrayArg(Eval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            int n = refEval.getRow();
            int n2 = refEval.getColumn();
            AreaPtg areaPtg = new AreaPtg(n, n, n2, n2, false, false, false, false);
            ValueEval valueEval = refEval.getInnerValueEval();
            return new Area2DEval(areaPtg, new ValueEval[]{valueEval});
        }
        throw EvaluationException.invalidValue();
    }

    public static boolean resolveRangeLookupArg(Eval eval, int n, short s) throws EvaluationException {
        if (eval == null) {
            return true;
        }
        ValueEval valueEval = OperandResolver.getSingleValue(eval, n, s);
        if (valueEval instanceof BlankEval) {
            return false;
        }
        if (valueEval instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)valueEval;
            return boolEval.getBooleanValue();
        }
        if (valueEval instanceof StringEval) {
            String string = ((StringEval)valueEval).getStringValue();
            if (string.length() < 1) {
                throw EvaluationException.invalidValue();
            }
            Boolean bl = Countif.parseBoolean(string);
            if (bl != null) {
                return bl;
            }
            throw EvaluationException.invalidValue();
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            return 0.0 != numericValueEval.getNumberValue();
        }
        throw new RuntimeException("Unexpected eval type (" + valueEval.getClass().getName() + ")");
    }

    public static int lookupIndexOfValue(ValueEval valueEval, ValueVector valueVector, boolean bl) throws EvaluationException {
        LookupValueComparer lookupValueComparer = LookupUtils.createLookupComparer(valueEval);
        int n = bl ? LookupUtils.performBinarySearch(valueVector, lookupValueComparer) : LookupUtils.lookupIndexOfExactValue(lookupValueComparer, valueVector);
        if (n < 0) {
            throw new EvaluationException(ErrorEval.NA);
        }
        return n;
    }

    private static int lookupIndexOfExactValue(LookupValueComparer lookupValueComparer, ValueVector valueVector) {
        int n = valueVector.getSize();
        for (int i = 0; i < n; ++i) {
            if (!lookupValueComparer.compareTo(valueVector.getItem(i)).isEqual()) continue;
            return i;
        }
        return -1;
    }

    private static int performBinarySearch(ValueVector valueVector, LookupValueComparer lookupValueComparer) {
        BinarySearchIndexes binarySearchIndexes = new BinarySearchIndexes(valueVector.getSize());
        int n;
        while ((n = binarySearchIndexes.getMidIx()) >= 0) {
            CompareResult compareResult = lookupValueComparer.compareTo(valueVector.getItem(n));
            if (compareResult.isTypeMismatch()) {
                int n2 = LookupUtils.handleMidValueTypeMismatch(lookupValueComparer, valueVector, binarySearchIndexes, n);
                if (n2 < 0) continue;
                n = n2;
                compareResult = lookupValueComparer.compareTo(valueVector.getItem(n));
            }
            if (compareResult.isEqual()) {
                return LookupUtils.findLastIndexInRunOfEqualValues(lookupValueComparer, valueVector, n, binarySearchIndexes.getHighIx());
            }
            binarySearchIndexes.narrowSearch(n, compareResult.isLessThan());
        }
        return binarySearchIndexes.getLowIx();
    }

    private static int handleMidValueTypeMismatch(LookupValueComparer lookupValueComparer, ValueVector valueVector, BinarySearchIndexes binarySearchIndexes, int n) {
        CompareResult compareResult;
        int n2 = n;
        int n3 = binarySearchIndexes.getHighIx();
        do {
            if (++n2 == n3) {
                binarySearchIndexes.narrowSearch(n, true);
                return -1;
            }
            compareResult = lookupValueComparer.compareTo(valueVector.getItem(n2));
            if (!compareResult.isLessThan() || n2 != n3 - 1) continue;
            binarySearchIndexes.narrowSearch(n, true);
            return -1;
        } while (compareResult.isTypeMismatch());
        if (compareResult.isEqual()) {
            return n2;
        }
        binarySearchIndexes.narrowSearch(n2, compareResult.isLessThan());
        return -1;
    }

    private static int findLastIndexInRunOfEqualValues(LookupValueComparer lookupValueComparer, ValueVector valueVector, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            if (lookupValueComparer.compareTo(valueVector.getItem(i)).isEqual()) continue;
            return i - 1;
        }
        return n2 - 1;
    }

    public static LookupValueComparer createLookupComparer(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof BlankEval) {
            throw new EvaluationException(ErrorEval.NA);
        }
        if (valueEval instanceof StringEval) {
            return new StringLookupComparer((StringEval)valueEval);
        }
        if (valueEval instanceof NumberEval) {
            return new NumberLookupComparer((NumberEval)valueEval);
        }
        if (valueEval instanceof BoolEval) {
            return new BooleanLookupComparer((BoolEval)valueEval);
        }
        throw new IllegalArgumentException("Bad lookup value type (" + valueEval.getClass().getName() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class BinarySearchIndexes {
        private int _lowIx = -1;
        private int _highIx;

        public BinarySearchIndexes(int n) {
            this._highIx = n;
        }

        public int getMidIx() {
            int n = this._highIx - this._lowIx;
            if (n < 2) {
                return -1;
            }
            return this._lowIx + n / 2;
        }

        public int getLowIx() {
            return this._lowIx;
        }

        public int getHighIx() {
            return this._highIx;
        }

        public void narrowSearch(int n, boolean bl) {
            if (bl) {
                this._highIx = n;
            } else {
                this._lowIx = n;
            }
        }
    }

    private static final class BooleanLookupComparer
    extends LookupValueComparerBase {
        private boolean _value;

        protected BooleanLookupComparer(BoolEval boolEval) {
            super(boolEval);
            this._value = boolEval.getBooleanValue();
        }

        protected CompareResult compareSameType(ValueEval valueEval) {
            BoolEval boolEval = (BoolEval)valueEval;
            boolean bl = boolEval.getBooleanValue();
            if (this._value == bl) {
                return CompareResult.EQUAL;
            }
            if (this._value) {
                return CompareResult.GREATER_THAN;
            }
            return CompareResult.LESS_THAN;
        }

        protected String getValueAsString() {
            return String.valueOf(this._value);
        }
    }

    private static final class NumberLookupComparer
    extends LookupValueComparerBase {
        private double _value;

        protected NumberLookupComparer(NumberEval numberEval) {
            super(numberEval);
            this._value = numberEval.getNumberValue();
        }

        protected CompareResult compareSameType(ValueEval valueEval) {
            NumberEval numberEval = (NumberEval)valueEval;
            return CompareResult.valueOf(Double.compare(this._value, numberEval.getNumberValue()));
        }

        protected String getValueAsString() {
            return String.valueOf(this._value);
        }
    }

    private static final class StringLookupComparer
    extends LookupValueComparerBase {
        private String _value;

        protected StringLookupComparer(StringEval stringEval) {
            super(stringEval);
            this._value = stringEval.getStringValue();
        }

        protected CompareResult compareSameType(ValueEval valueEval) {
            StringEval stringEval = (StringEval)valueEval;
            return CompareResult.valueOf(this._value.compareToIgnoreCase(stringEval.getStringValue()));
        }

        protected String getValueAsString() {
            return this._value;
        }
    }

    private static abstract class LookupValueComparerBase
    implements LookupValueComparer {
        private final Class _targetClass;

        protected LookupValueComparerBase(ValueEval valueEval) {
            if (valueEval == null) {
                throw new RuntimeException("targetValue cannot be null");
            }
            this._targetClass = valueEval.getClass();
        }

        public final CompareResult compareTo(ValueEval valueEval) {
            if (valueEval == null) {
                throw new RuntimeException("compare to value cannot be null");
            }
            if (this._targetClass != valueEval.getClass()) {
                return CompareResult.TYPE_MISMATCH;
            }
            if (this._targetClass == (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval = LookupUtils.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval)) {
                // empty if block
            }
            return this.compareSameType(valueEval);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected abstract CompareResult compareSameType(ValueEval var1);

        protected abstract String getValueAsString();
    }

    public static interface LookupValueComparer {
        public CompareResult compareTo(ValueEval var1);
    }

    public static final class CompareResult {
        private final boolean _isTypeMismatch;
        private final boolean _isLessThan;
        private final boolean _isEqual;
        private final boolean _isGreaterThan;
        public static final CompareResult TYPE_MISMATCH = new CompareResult(true, 0);
        public static final CompareResult LESS_THAN = new CompareResult(false, -1);
        public static final CompareResult EQUAL = new CompareResult(false, 0);
        public static final CompareResult GREATER_THAN = new CompareResult(false, 1);

        private CompareResult(boolean bl, int n) {
            if (bl) {
                this._isTypeMismatch = true;
                this._isLessThan = false;
                this._isEqual = false;
                this._isGreaterThan = false;
            } else {
                this._isTypeMismatch = false;
                this._isLessThan = n < 0;
                this._isEqual = n == 0;
                this._isGreaterThan = n > 0;
            }
        }

        public static final CompareResult valueOf(int n) {
            if (n < 0) {
                return LESS_THAN;
            }
            if (n > 0) {
                return GREATER_THAN;
            }
            return EQUAL;
        }

        public boolean isTypeMismatch() {
            return this._isTypeMismatch;
        }

        public boolean isLessThan() {
            return this._isLessThan;
        }

        public boolean isEqual() {
            return this._isEqual;
        }

        public boolean isGreaterThan() {
            return this._isGreaterThan;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this.formatAsString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        private String formatAsString() {
            if (this._isTypeMismatch) {
                return "TYPE_MISMATCH";
            }
            if (this._isLessThan) {
                return "LESS_THAN";
            }
            if (this._isEqual) {
                return "EQUAL";
            }
            if (this._isGreaterThan) {
                return "GREATER_THAN";
            }
            return "??error??";
        }
    }

    public static interface ValueVector {
        public ValueEval getItem(int var1);

        public int getSize();
    }
}

