/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Lookup
implements Function {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        switch (evalArray.length) {
            case 3: {
                break;
            }
            case 2: {
                throw new RuntimeException("Two arg version of LOOKUP not supported yet");
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ValueEval valueEval = OperandResolver.getSingleValue(evalArray[0], n, s);
            AreaEval areaEval = LookupUtils.resolveTableArrayArg(evalArray[1]);
            AreaEval areaEval2 = LookupUtils.resolveTableArrayArg(evalArray[2]);
            LookupUtils.ValueVector valueVector = Lookup.createVector(areaEval);
            LookupUtils.ValueVector valueVector2 = Lookup.createVector(areaEval2);
            if (valueVector.getSize() > valueVector2.getSize()) {
                throw new RuntimeException("Lookup vector and result vector of differing sizes not supported yet");
            }
            int n2 = LookupUtils.lookupIndexOfValue(valueEval, valueVector, true);
            return valueVector2.getItem(n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static LookupUtils.ValueVector createVector(AreaEval areaEval) {
        if (!areaEval.isRow() && !areaEval.isColumn()) {
            throw new RuntimeException("non-vector lookup or result areas not supported yet");
        }
        return new SimpleValueVector(areaEval.getValues());
    }

    private static final class SimpleValueVector
    implements LookupUtils.ValueVector {
        private final ValueEval[] _values;

        public SimpleValueVector(ValueEval[] valueEvalArray) {
            this._values = valueEvalArray;
        }

        public ValueEval getItem(int n) {
            return this._values[n];
        }

        public int getSize() {
            return this._values.length;
        }
    }
}

