/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.MathX;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;

public class Floor
extends NumericFunction {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        double d = 0.0;
        double d2 = 0.0;
        ErrorEval errorEval = null;
        switch (evalArray.length) {
            default: {
                errorEval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 2: {
                NumericValueEval numericValueEval;
                ValueEval valueEval = this.singleOperandEvaluate(evalArray[0], n, s);
                if (valueEval instanceof NumericValueEval) {
                    numericValueEval = (NumericValueEval)valueEval;
                    d = numericValueEval.getNumberValue();
                } else if (!(valueEval instanceof BlankEval)) {
                    errorEval = ErrorEval.NUM_ERROR;
                }
                if (errorEval != null) break;
                valueEval = this.singleOperandEvaluate(evalArray[1], n, s);
                if (valueEval instanceof NumericValueEval) {
                    numericValueEval = (NumericValueEval)valueEval;
                    d2 = numericValueEval.getNumberValue();
                    break;
                }
                if (valueEval instanceof BlankEval) break;
                errorEval = ErrorEval.NUM_ERROR;
            }
        }
        if (errorEval == null) {
            double d3 = MathX.floor(d, d2);
            errorEval = Double.isNaN(d3) || Double.isInfinite(d3) ? ErrorEval.NUM_ERROR : new NumberEval(d3);
        }
        return errorEval;
    }
}

