/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import java.util.Calendar;
import java.util.Date;

public class Day
extends NumericFunction {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        ValueEval valueEval = null;
        switch (evalArray.length) {
            default: {
                valueEval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval valueEval2 = this.singleOperandEvaluate(evalArray[0], n, s);
                if (valueEval2 instanceof NumericValueEval) {
                    NumericValueEval numericValueEval = (NumericValueEval)valueEval2;
                    if (HSSFDateUtil.isValidExcelDate(numericValueEval.getNumberValue())) {
                        Date date = HSSFDateUtil.getJavaDate(numericValueEval.getNumberValue(), false);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        valueEval = new NumberEval(calendar.get(5));
                        break;
                    }
                    valueEval = ErrorEval.NUM_ERROR;
                    break;
                }
                if (valueEval2 instanceof BlankEval) break;
                valueEval = ErrorEval.NUM_ERROR;
            }
        }
        return valueEval;
    }
}

