/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import java.util.GregorianCalendar;

public class Date
extends NumericFunction {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        ValueEval[] valueEvalArray;
        if (evalArray.length == 3 && this.validValues(valueEvalArray = new ValueEval[]{this.singleOperandEvaluate(evalArray[0], n, s), this.singleOperandEvaluate(evalArray[1], n, s), this.singleOperandEvaluate(evalArray[2], n, s)})) {
            int n2 = this.getYear(valueEvalArray[0]);
            int n3 = (int)((NumericValueEval)valueEvalArray[1]).getNumberValue() - 1;
            int n4 = (int)((NumericValueEval)valueEvalArray[2]).getNumberValue();
            if (n2 < 0 || n3 < 0 || n4 < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            if (n2 == 1900 && n3 == 1 && n4 == 29) {
                return new NumberEval(60.0);
            }
            if (n2 == 1900 && (n3 == 0 && n4 >= 60 || n3 == 1 && n4 >= 30)) {
                --n4;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(n2, n3, n4, 0, 0, 0);
            gregorianCalendar.set(14, 0);
            return new NumberEval(HSSFDateUtil.getExcelDate(gregorianCalendar.getTime(), false));
        }
        return ErrorEval.VALUE_INVALID;
    }

    private int getYear(ValueEval valueEval) {
        int n = (int)((NumericValueEval)valueEval).getNumberValue();
        if (n < 0) {
            return -1;
        }
        return n < 1900 ? 1900 + n : n;
    }

    private boolean validValues(ValueEval[] valueEvalArray) {
        for (int i = 0; i < valueEvalArray.length; ++i) {
            ValueEval valueEval = valueEvalArray[i];
            if (valueEval instanceof RefEval) {
                RefEval refEval = (RefEval)valueEval;
                ValueEval valueEval2 = refEval.getInnerValueEval();
                if (valueEval2 instanceof BlankEval) {
                    valueEval = new NumberEval(0.0);
                } else if (valueEval2 instanceof NumericValueEval) {
                    valueEval = valueEval2;
                } else {
                    return false;
                }
            }
            if (valueEval instanceof NumericValueEval) continue;
            return false;
        }
        return true;
    }
}

