/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public final class Countif
implements Function {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        Object object;
        switch (evalArray.length) {
            case 2: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        AreaEval areaEval = (AreaEval)evalArray[0];
        Eval eval = evalArray[1];
        if (eval instanceof RefEval) {
            object = (RefEval)eval;
            eval = object.getInnerValueEval();
        }
        object = Countif.createCriteriaPredicate(eval);
        return this.countMatchingCellsInArea(areaEval, (I_MatchPredicate)object);
    }

    private Eval countMatchingCellsInArea(AreaEval areaEval, I_MatchPredicate i_MatchPredicate) {
        ValueEval[] valueEvalArray = areaEval.getValues();
        int n = 0;
        for (int i = 0; i < valueEvalArray.length; ++i) {
            if (!i_MatchPredicate.matches(valueEvalArray[i])) continue;
            ++n;
        }
        return new NumberEval(n);
    }

    private static I_MatchPredicate createCriteriaPredicate(Eval eval) {
        if (eval instanceof NumberEval) {
            return new NumberMatcher(((NumberEval)eval).getNumberValue());
        }
        if (eval instanceof BoolEval) {
            return new BooleanMatcher(((BoolEval)eval).getBooleanValue());
        }
        if (eval instanceof StringEval) {
            return Countif.createGeneralMatchPredicate((StringEval)eval);
        }
        throw new RuntimeException("Unexpected type for criteria (" + eval.getClass().getName() + ")");
    }

    private static I_MatchPredicate createGeneralMatchPredicate(StringEval stringEval) {
        String string = stringEval.getStringValue();
        char c = string.charAt(0);
        Boolean bl = Countif.parseBoolean(string);
        if (bl != null) {
            return new BooleanMatcher(bl);
        }
        Double d = Countif.parseDouble(string);
        if (d != null) {
            return new NumberMatcher(d);
        }
        switch (c) {
            case '<': 
            case '=': 
            case '>': {
                throw new RuntimeException("Incomplete code - criteria expressions such as '" + string + "' not supported yet");
            }
        }
        return new StringMatcher(string);
    }

    static Double parseDouble(String string) {
        double d;
        if (!Character.isDigit(string.charAt(0))) {
            return null;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Double(d);
    }

    static Boolean parseBoolean(String string) {
        switch (string.charAt(0)) {
            case 'T': 
            case 't': {
                if (!"TRUE".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 'F': 
            case 'f': {
                if (!"FALSE".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static final class StringMatcher
    implements I_MatchPredicate {
        private final String _value;

        public StringMatcher(String string) {
            this._value = string;
        }

        public boolean matches(Eval eval) {
            if (!(eval instanceof StringEval)) {
                return false;
            }
            StringEval stringEval = (StringEval)eval;
            return stringEval.getStringValue() == this._value;
        }
    }

    private static final class BooleanMatcher
    implements I_MatchPredicate {
        private final boolean _value;

        public BooleanMatcher(boolean bl) {
            this._value = bl;
        }

        public boolean matches(Eval eval) {
            if (eval instanceof StringEval) {
                StringEval stringEval = (StringEval)eval;
                Boolean bl = Countif.parseBoolean(stringEval.getStringValue());
                if (bl == null) {
                    return false;
                }
                return false;
            }
            if (!(eval instanceof BoolEval)) {
                return false;
            }
            BoolEval boolEval = (BoolEval)eval;
            return boolEval.getBooleanValue() == this._value;
        }
    }

    private static final class NumberMatcher
    implements I_MatchPredicate {
        private final double _value;

        public NumberMatcher(double d) {
            this._value = d;
        }

        public boolean matches(Eval eval) {
            if (eval instanceof StringEval) {
                StringEval stringEval = (StringEval)eval;
                Double d = Countif.parseDouble(stringEval.getStringValue());
                if (d == null) {
                    return false;
                }
                return d == this._value;
            }
            if (!(eval instanceof NumberEval)) {
                return false;
            }
            NumberEval numberEval = (NumberEval)eval;
            return numberEval.getNumberValue() == this._value;
        }
    }

    private static interface I_MatchPredicate {
        public boolean matches(Eval var1);
    }
}

