/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public final class Counta
implements Function {
    public Eval evaluate(Eval[] evalArray, int n, short s) {
        int n2 = evalArray.length;
        if (n2 < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n2 > 30) {
            return ErrorEval.VALUE_INVALID;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += Counta.countArg(evalArray[i]);
        }
        return new NumberEval(n3);
    }

    private static int countArg(Eval eval) {
        if (eval instanceof AreaEval) {
            AreaEval areaEval = (AreaEval)eval;
            return Counta.countAreaEval(areaEval);
        }
        if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            return Counta.countValue(refEval.getInnerValueEval());
        }
        if (eval instanceof NumberEval) {
            return 1;
        }
        if (eval instanceof StringEval) {
            return 1;
        }
        throw new RuntimeException("Unexpected eval type (" + eval.getClass().getName() + ")");
    }

    private static int countAreaEval(AreaEval areaEval) {
        int n = 0;
        ValueEval[] valueEvalArray = areaEval.getValues();
        for (int i = 0; i < valueEvalArray.length; ++i) {
            ValueEval valueEval = valueEvalArray[i];
            if (valueEval == null) continue;
            n += Counta.countValue(valueEval);
        }
        return n;
    }

    private static int countValue(ValueEval valueEval) {
        if (valueEval == BlankEval.INSTANCE) {
            return 0;
        }
        if (valueEval instanceof BlankEval) {
            return 0;
        }
        if (valueEval instanceof ErrorEval) {
            return 1;
        }
        return 1;
    }
}

