/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.function;

import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadataReader;
import java.util.Map;
import java.util.Set;

public final class FunctionMetadataRegistry {
    public static final String FUNCTION_NAME_IF = "IF";
    public static final short FUNCTION_INDEX_EXTERNAL = 255;
    private static FunctionMetadataRegistry _instance;
    private final FunctionMetadata[] _functionDataByIndex;
    private final Map _functionDataByName;

    private static FunctionMetadataRegistry getInstance() {
        if (_instance == null) {
            _instance = FunctionMetadataReader.createRegistry();
        }
        return _instance;
    }

    FunctionMetadataRegistry(FunctionMetadata[] functionMetadataArray, Map map) {
        this._functionDataByIndex = functionMetadataArray;
        this._functionDataByName = map;
    }

    Set getAllFunctionNames() {
        return this._functionDataByName.keySet();
    }

    public static FunctionMetadata getFunctionByIndex(int n) {
        return FunctionMetadataRegistry.getInstance().getFunctionByIndexInternal(n);
    }

    private FunctionMetadata getFunctionByIndexInternal(int n) {
        return this._functionDataByIndex[n];
    }

    public static short lookupIndexByName(String string) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getInstance().getFunctionByNameInternal(string);
        if (functionMetadata == null) {
            return -1;
        }
        return (short)functionMetadata.getIndex();
    }

    private FunctionMetadata getFunctionByNameInternal(String string) {
        return (FunctionMetadata)this._functionDataByName.get(string);
    }

    public static FunctionMetadata getFunctionByName(String string) {
        return FunctionMetadataRegistry.getInstance().getFunctionByNameInternal(string);
    }
}

