/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class ValueEvalToNumericXlator {
    public static final int STRING_IS_PARSED = 1;
    public static final int BOOL_IS_PARSED = 2;
    public static final int BLANK_IS_PARSED = 4;
    public static final int REF_STRING_IS_PARSED = 8;
    public static final int REF_BOOL_IS_PARSED = 16;
    public static final int REF_BLANK_IS_PARSED = 32;
    public static final int STRING_IS_INVALID_VALUE = 2048;
    private final int flags;

    public ValueEvalToNumericXlator(int n) {
        this.flags = n;
    }

    public ValueEval attemptXlateToNumeric(ValueEval valueEval) {
        ValueEval valueEval2 = null;
        if (valueEval == null) {
            valueEval2 = BlankEval.INSTANCE;
        } else if (valueEval instanceof NumberEval) {
            valueEval2 = valueEval;
        } else if (valueEval instanceof BoolEval) {
            valueEval2 = (this.flags & 2) > 0 ? (NumericValueEval)valueEval : this.xlateBlankEval(4);
        } else if (valueEval instanceof StringEval) {
            valueEval2 = this.xlateStringEval((StringEval)valueEval);
        } else if (valueEval instanceof RefEval) {
            valueEval2 = this.xlateRefEval((RefEval)valueEval);
        } else if (valueEval instanceof ErrorEval) {
            valueEval2 = valueEval;
        } else if (valueEval instanceof BlankEval) {
            valueEval2 = this.xlateBlankEval(4);
        } else {
            throw new RuntimeException("Invalid ValueEval type passed for conversion: " + valueEval.getClass());
        }
        return valueEval2;
    }

    private ValueEval xlateBlankEval(int n) {
        return (this.flags & n) > 0 ? NumberEval.ZERO : BlankEval.INSTANCE;
    }

    private ValueEval xlateRefEval(RefEval refEval) {
        ValueEval valueEval = refEval.getInnerValueEval();
        if (valueEval instanceof NumberEval) {
            return valueEval;
        }
        if (valueEval instanceof BoolEval) {
            return (this.flags & 0x10) > 0 ? valueEval : BlankEval.INSTANCE;
        }
        if (valueEval instanceof StringEval) {
            return this.xlateRefStringEval((StringEval)valueEval);
        }
        if (valueEval instanceof ErrorEval) {
            return valueEval;
        }
        if (valueEval instanceof BlankEval) {
            return this.xlateBlankEval(32);
        }
        throw new RuntimeException("Invalid ValueEval type passed for conversion: (" + valueEval.getClass().getName() + ")");
    }

    private ValueEval xlateStringEval(StringEval stringEval) {
        if ((this.flags & 1) > 0) {
            String string = stringEval.getStringValue();
            Double d = OperandResolver.parseDouble(string);
            if (d == null) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(d);
        }
        if ((this.flags & 0x800) > 0) {
            return ErrorEval.VALUE_INVALID;
        }
        return this.xlateBlankEval(4);
    }

    private ValueEval xlateRefStringEval(StringEval stringEval) {
        if ((this.flags & 8) > 0) {
            String string = stringEval.getStringValue();
            Double d = OperandResolver.parseDouble(string);
            if (d == null) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(d);
        }
        return BlankEval.INSTANCE;
    }
}

