/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperationEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class UnaryPlusEval
implements OperationEval {
    private UnaryPlusPtg delegate;

    public UnaryPlusEval(Ptg ptg) {
        this.delegate = (UnaryPlusPtg)ptg;
    }

    public Eval evaluate(Eval[] evalArray, int n, short s) {
        double d;
        if (evalArray.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval valueEval = OperandResolver.getSingleValue(evalArray[0], n, s);
            if (valueEval instanceof BlankEval) {
                return NumberEval.ZERO;
            }
            if (valueEval instanceof StringEval) {
                return valueEval;
            }
            d = OperandResolver.coerceValueToDouble(valueEval);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

